/*
 * Decompiled with CFR 0.152.
 */
package net.chris.chris_s_additions.block.block_entity;

import java.util.List;
import net.chris.chris_s_additions.block.block_entity.ModBlockEntities;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4140;
import net.minecraft.class_5253;
import org.apache.commons.lang3.mutable.MutableInt;

public class OldBellBlockEntity
extends class_2586 {
    private long lastRingTime;
    public int ringTicks;
    public boolean ringing;
    public class_2350 lastSideHit;
    private List<class_1309> hearingEntities;
    private boolean resonating;
    private int resonateTime;

    public OldBellBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.OLD_BELL, pos, state);
    }

    public boolean method_11004(int type, int data) {
        if (type == 1) {
            this.notifyMemoriesOfBell();
            this.resonateTime = 0;
            this.lastSideHit = class_2350.method_10143((int)data);
            this.ringTicks = 0;
            this.ringing = true;
            return true;
        }
        return super.method_11004(type, data);
    }

    private static void tick(class_1937 world, class_2338 pos, class_2680 state, OldBellBlockEntity blockEntity, Effect bellEffect) {
        if (blockEntity.ringing) {
            ++blockEntity.ringTicks;
        }
        if (blockEntity.ringTicks >= 50) {
            blockEntity.ringing = false;
            blockEntity.ringTicks = 0;
        }
        if (blockEntity.ringTicks >= 5 && blockEntity.resonateTime == 0 && OldBellBlockEntity.affectedEntitiesHearBell(pos, blockEntity.hearingEntities)) {
            blockEntity.resonating = true;
            world.method_8396(null, pos, class_3417.field_19167, class_3419.field_15245, 1.0f, 0.75f);
        }
        if (blockEntity.resonating) {
            if (blockEntity.resonateTime < 40) {
                ++blockEntity.resonateTime;
            } else {
                bellEffect.run(world, pos, blockEntity.hearingEntities);
                blockEntity.resonating = false;
            }
        }
    }

    public static void clientTick(class_1937 world, class_2338 pos, class_2680 state, OldBellBlockEntity blockEntity) {
        OldBellBlockEntity.tick(world, pos, state, blockEntity, OldBellBlockEntity::applyParticlesToAffected);
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, OldBellBlockEntity blockEntity) {
        OldBellBlockEntity.tick(world, pos, state, blockEntity, OldBellBlockEntity::applyGlowToAffected);
    }

    public void activate(class_2350 direction) {
        class_2338 blockPos = this.method_11016();
        this.lastSideHit = direction;
        if (this.ringing) {
            this.ringTicks = 0;
        } else {
            this.ringing = true;
        }
        this.field_11863.method_8427(blockPos, this.method_11010().method_26204(), 1, direction.method_10146());
    }

    private void notifyMemoriesOfBell() {
        class_2338 blockPos = this.method_11016();
        if (this.field_11863.method_8510() > this.lastRingTime + 60L || this.hearingEntities == null) {
            this.lastRingTime = this.field_11863.method_8510();
            class_238 box = new class_238(blockPos).method_1014(48.0);
            this.hearingEntities = this.field_11863.method_18467(class_1309.class, box);
        }
        if (!this.field_11863.field_9236) {
            for (class_1309 livingEntity : this.hearingEntities) {
                if (!livingEntity.method_5805() || livingEntity.method_31481() || !blockPos.method_19769((class_2374)livingEntity.method_19538(), 32.0)) continue;
                livingEntity.method_18868().method_18878(class_4140.field_19009, (Object)this.field_11863.method_8510());
            }
        }
    }

    private static boolean affectedEntitiesHearBell(class_2338 pos, List<class_1309> hearingEntities) {
        for (class_1309 livingEntity : hearingEntities) {
            if (!livingEntity.method_5805() || livingEntity.method_31481() || !pos.method_19769((class_2374)livingEntity.method_19538(), 24.0) || livingEntity.method_6046() != class_1310.field_6289) continue;
            return true;
        }
        return false;
    }

    private static void applyGlowToAffected(class_1937 world, class_2338 pos, List<class_1309> hearingEntities) {
        hearingEntities.stream().filter(entity -> OldBellBlockEntity.isAffectedEntity(pos, entity)).forEach(OldBellBlockEntity::applyGlowToEntity);
    }

    private static void applyParticlesToAffected(class_1937 world, class_2338 pos, List<class_1309> hearingEntities) {
        MutableInt mutableInt = new MutableInt(16700985);
        int i = (int)hearingEntities.stream().filter(entity -> pos.method_19769((class_2374)entity.method_19538(), 32.0)).count();
        hearingEntities.stream().filter(entity -> OldBellBlockEntity.isAffectedEntity(pos, entity)).forEach(entity -> {
            float f = 1.0f;
            double d = Math.sqrt((entity.method_23317() - (double)pos.method_10263()) * (entity.method_23317() - (double)pos.method_10263()) + (entity.method_23321() - (double)pos.method_10260()) * (entity.method_23321() - (double)pos.method_10260()));
            double e = (double)((float)pos.method_10263() + 0.5f) + 1.0 / d * (entity.method_23317() - (double)pos.method_10263());
            double g = (double)((float)pos.method_10260() + 0.5f) + 1.0 / d * (entity.method_23321() - (double)pos.method_10260());
            int j = class_3532.method_15340((int)((i - 21) / -2), (int)3, (int)15);
            for (int k = 0; k < j; ++k) {
                int l = mutableInt.addAndGet(5);
                double h = (double)class_5253.class_5254.method_27765((int)l) / 255.0;
                double m = (double)class_5253.class_5254.method_27766((int)l) / 255.0;
                double n = (double)class_5253.class_5254.method_27767((int)l) / 255.0;
                world.method_8406((class_2394)class_2398.field_11226, e, (double)((float)pos.method_10264() + 0.5f), g, h, m, n);
            }
        });
    }

    private static boolean isAffectedEntity(class_2338 pos, class_1309 entity) {
        return entity.method_5805() && !entity.method_31481() && pos.method_19769((class_2374)entity.method_19538(), 32.0) && entity.method_6046() == class_1310.field_6289;
    }

    private static void applyGlowToEntity(class_1309 entity) {
        entity.method_6092(new class_1293(class_1294.field_5912, 60));
    }

    @FunctionalInterface
    static interface Effect {
        public void run(class_1937 var1, class_2338 var2, List<class_1309> var3);
    }
}

