/*
 * Decompiled with CFR 0.152.
 */
package net.chris.chris_s_additions.block.custom.misc;

import java.util.List;
import java.util.Map;
import net.chris.chris_s_additions.block.custom.misc.UmbrellaBlockClient;
import net.chris.chris_s_additions.block.custom.properties.UmbrellaBlockShape;
import net.minecraft.class_10;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_437;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class UmbrellaBlock
extends class_2248
implements class_3737 {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2746 THIN = class_2746.method_11825((String)"thin");
    public static final class_2754<UmbrellaBlockShape> PART = class_2754.method_11850((String)"part", UmbrellaBlockShape.class);
    private static final ThreadLocal<Boolean> breakingInCreative = ThreadLocal.withInitial(() -> false);
    private static final Map<UmbrellaBlockShape, class_265> SHAPES = Map.ofEntries(Map.entry(UmbrellaBlockShape.NORTH, class_2248.method_9541((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)12.0, (double)14.0)), Map.entry(UmbrellaBlockShape.SOUTH, class_2248.method_9541((double)0.0, (double)6.0, (double)2.0, (double)16.0, (double)12.0, (double)16.0)), Map.entry(UmbrellaBlockShape.EAST, class_2248.method_9541((double)0.0, (double)6.0, (double)0.0, (double)14.0, (double)12.0, (double)16.0)), Map.entry(UmbrellaBlockShape.WEST, class_2248.method_9541((double)2.0, (double)6.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0)), Map.entry(UmbrellaBlockShape.SOUTH_WEST, class_2248.method_9541((double)2.0, (double)6.0, (double)2.0, (double)16.0, (double)12.0, (double)16.0)), Map.entry(UmbrellaBlockShape.SOUTH_EAST, class_2248.method_9541((double)0.0, (double)6.0, (double)2.0, (double)14.0, (double)12.0, (double)16.0)), Map.entry(UmbrellaBlockShape.NORTH_WEST, class_2248.method_9541((double)2.0, (double)6.0, (double)0.0, (double)16.0, (double)12.0, (double)14.0)), Map.entry(UmbrellaBlockShape.NORTH_EAST, class_2248.method_9541((double)0.0, (double)6.0, (double)0.0, (double)14.0, (double)12.0, (double)14.0)), Map.entry(UmbrellaBlockShape.CENTER, class_259.method_1084((class_265)class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), (class_265)class_2248.method_9541((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0))));
    private static final class_265 COLLISION_SHAPE = class_2248.method_9541((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)12.2, (double)16.0);
    private final class_1767 color;
    private final class_2498 edgeSoundGroup;
    private final class_2498 centerSoundGroup;
    private final String DyeabletooltipLetter;

    public UmbrellaBlock(class_1767 color, String dyeabletooltipLetter, class_4970.class_2251 settings, class_2498 edgeSoundGroup, class_2498 centerSoundGroup) {
        super(settings);
        this.color = color;
        this.DyeabletooltipLetter = dyeabletooltipLetter;
        this.edgeSoundGroup = edgeSoundGroup;
        this.centerSoundGroup = centerSoundGroup;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(PART, (Comparable)((Object)UmbrellaBlockShape.CENTER))).method_11657((class_2769)THIN, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public class_1767 getColor() {
        return this.color;
    }

    public class_2498 method_9573(class_2680 state) {
        UmbrellaBlockShape part = (UmbrellaBlockShape)((Object)state.method_11654(PART));
        return part == UmbrellaBlockShape.CENTER ? this.centerSoundGroup : this.edgeSoundGroup;
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return COLLISION_SHAPE;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPES.getOrDefault(state.method_11654(PART), class_259.method_1073());
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_1937 world = ctx.method_8045();
        class_2338 origin = ctx.method_8037();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                class_2338 checkPos = origin.method_10069(dx, 0, dz);
                if (world.method_8320(checkPos).method_26166(ctx)) continue;
                if (ctx.method_8036() != null) {
                    class_1657 player = ctx.method_8036();
                    if (world instanceof class_1937) {
                        class_1937 realWorld = world;
                        if (realWorld.field_9236) {
                            player.method_7353((class_2561)class_2561.method_43471((String)"text.no_space_to_place").method_27692(class_124.field_1061), true);
                            UmbrellaBlockClient.showPlacementOutline(origin);
                            class_310.method_1551().field_1724.method_17356(class_3417.field_26963, class_3419.field_15248, 0.5f, 1.2f);
                        }
                    }
                }
                return null;
            }
        }
        class_2338 below = origin.method_10074();
        boolean isThin = this.calculateIsThin((class_1936)world, below);
        class_3610 fluidState = world.method_8316(origin);
        boolean waterlogged = fluidState.method_15772() == class_3612.field_15910;
        class_2680 newState = (class_2680)((class_2680)((class_2680)this.method_9564().method_11657(PART, (Comparable)((Object)UmbrellaBlockShape.CENTER))).method_11657((class_2769)THIN, (Comparable)Boolean.valueOf(isThin))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
        if (world instanceof class_1937) {
            class_1937 realWorld = world;
            if (realWorld.field_9236) {
                UmbrellaBlockClient.clearPlacementOutline();
            }
        }
        return newState;
    }

    private boolean calculateIsThin(class_1936 world, class_2338 posBelow) {
        class_2680 belowState = world.method_8320(posBelow);
        class_265 belowShape = belowState.method_26220((class_1922)world, posBelow);
        class_265 topFaceShape = belowShape.method_20538(class_2350.field_11036);
        if (topFaceShape.method_1110()) {
            return true;
        }
        double maxXSize = 0.0;
        double maxZSize = 0.0;
        for (class_238 box : topFaceShape.method_1090()) {
            double xSize = box.field_1320 - box.field_1323;
            double zSize = box.field_1324 - box.field_1321;
            if (xSize > maxXSize) {
                maxXSize = xSize;
            }
            if (!(zSize > maxZSize)) continue;
            maxZSize = zSize;
        }
        double avgSize = (maxXSize + maxZSize) / 2.0 * 16.0;
        return avgSize < 4.0;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        boolean isThin = (Boolean)state.method_11654((class_2769)THIN);
        for (UmbrellaBlockShape shape : UmbrellaBlockShape.values()) {
            class_2338 offsetPos = pos.method_10069(shape.getXOffset(), 0, shape.getYOffset());
            class_3610 fluidState = world.method_8316(offsetPos);
            boolean waterlogged = fluidState.method_15772() == class_3612.field_15910;
            class_2680 newState = (class_2680)((class_2680)((class_2680)this.method_9564().method_11657(PART, (Comparable)((Object)shape))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).method_11657((class_2769)THIN, (Comparable)Boolean.valueOf(isThin));
            world.method_8652(offsetPos, newState, 3);
        }
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return UmbrellaBlock.method_20044((class_4538)world, (class_2338)pos.method_10074(), (class_2350)class_2350.field_11036);
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!world.field_9236) {
            UmbrellaBlockShape part = (UmbrellaBlockShape)((Object)state.method_11654(PART));
            class_2338 centerPos = pos.method_10069(-part.getXOffset(), 0, -part.getYOffset());
            breakingInCreative.set(player.method_7337());
            this.breakUmbrella(world, centerPos, true);
            breakingInCreative.remove();
        }
        super.method_9576(world, pos, state, player);
    }

    public void breakUmbrella(class_1937 world, class_2338 centerPos, boolean dropItem) {
        boolean isCreative = breakingInCreative.get();
        for (UmbrellaBlockShape part : UmbrellaBlockShape.values()) {
            class_2338 partPos = centerPos.method_10069(part.getXOffset(), 0, part.getYOffset());
            class_2680 partState = world.method_8320(partPos);
            if (!(partState.method_26204() instanceof UmbrellaBlock)) continue;
            if (dropItem && part == UmbrellaBlockShape.CENTER && !isCreative) {
                class_2248.method_9577((class_1937)world, (class_2338)partPos, (class_1799)new class_1799((class_1935)this));
            }
            world.method_22352(partPos, false);
        }
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        UmbrellaBlockShape part;
        class_2338 centerPos;
        class_2680 centerState;
        if (!world.field_9236 && state.method_26204() != newState.method_26204() && (centerState = world.method_8320(centerPos = pos.method_10069(-(part = (UmbrellaBlockShape)((Object)state.method_11654(PART))).getXOffset(), 0, -part.getYOffset()))).method_26204() instanceof UmbrellaBlock && centerState.method_11654(PART) == UmbrellaBlockShape.CENTER && !centerPos.equals((Object)pos)) {
            this.breakUmbrella(world, centerPos, true);
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        UmbrellaBlockShape part = (UmbrellaBlockShape)((Object)state.method_11654(PART));
        if (part != UmbrellaBlockShape.CENTER) {
            class_2338 centerPos = pos.method_10069(-part.getXOffset(), 0, -part.getYOffset());
            class_2680 centerState = world.method_8320(centerPos);
            if (!(centerState.method_26204() instanceof UmbrellaBlock) || centerState.method_11654(PART) != UmbrellaBlockShape.CENTER) {
                return class_2246.field_10124.method_9564();
            }
        } else if (direction == class_2350.field_11033 && !this.method_9558(state, (class_4538)world, pos)) {
            if (world instanceof class_1937) {
                class_1937 realWorld = (class_1937)world;
                this.breakUmbrella(realWorld, pos, true);
            }
            return class_2246.field_10124.method_9564();
        }
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public void method_9586(class_1937 world, class_2338 pos, class_1927 explosion) {
        class_2680 state = world.method_8320(pos);
        if (!(state.method_26204() instanceof UmbrellaBlock) || !state.method_28498(PART)) {
            return;
        }
        UmbrellaBlockShape shape = (UmbrellaBlockShape)((Object)state.method_11654(PART));
        class_2338 centerPos = pos.method_10069(-shape.getXOffset(), 0, -shape.getYOffset());
        class_2680 centerState = world.method_8320(centerPos);
        if (centerState.method_26204() instanceof UmbrellaBlock && centerState.method_28498(PART) && centerState.method_11654(PART) == UmbrellaBlockShape.CENTER) {
            UmbrellaBlock.method_9577((class_1937)world, (class_2338)centerPos, (class_1799)new class_1799((class_1935)this));
            this.breakUmbrella(world, centerPos, true);
        }
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WATERLOGGED, PART, THIN});
    }

    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return false;
    }

    public void method_9554(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        super.method_9554(world, state, pos, entity, fallDistance * 0.5f);
    }

    public void method_9502(class_1922 world, class_1297 entity) {
        if (entity.method_21750()) {
            super.method_9502(world, entity);
        } else {
            this.bounceEntity(entity);
        }
    }

    private void bounceEntity(class_1297 entity) {
        class_243 vec3d = entity.method_18798();
        if (vec3d.field_1351 < 0.0) {
            double d = entity instanceof class_1309 ? 1.0 : 0.8;
            entity.method_18800(vec3d.field_1352, -vec3d.field_1351 * (double)0.66f * d, vec3d.field_1350);
        }
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 context) {
        if (class_437.method_25442()) {
            tooltip.add((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)this.DyeabletooltipLetter).method_27694(style -> style.method_36139(class_124.field_1068.method_532().intValue()).method_27704(new class_2960("chris_s_additions", "dyeable_tooltip_font")))));
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.block_3x3").method_27692(class_124.field_1068));
        } else {
            tooltip.add((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)this.DyeabletooltipLetter).method_27694(style -> style.method_36139(class_124.field_1068.method_532().intValue()).method_27704(new class_2960("chris_s_additions", "dyeable_tooltip_font")))));
            tooltip.add((class_2561)class_2561.method_43470((String)"Hold \u00a7e[SHIFT]\u00a7r for more info").method_27692(class_124.field_1080));
        }
    }
}

