/*
 * Decompiled with CFR 0.152.
 */
package net.chris.chris_s_additions.block.custom.misc.soul_oak;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.chris.chris_s_additions.block.AllBlocks;
import net.chris.chris_s_additions.item.AllItems;
import net.chris.chris_s_additions.particles.AllParticles;
import net.chris.chris_s_additions.util.ModTags;
import net.minecraft.class_10;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1820;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public class SoulOakBranchBlock
extends class_2248
implements class_3737 {
    public static final class_2753 FACING = class_2383.field_11177;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2746 LIT = class_2746.method_11825((String)"lit");
    public static final class_2758 SOUL_WAX_STAGE = class_2758.method_11867((String)"soul_wax_stage", (int)0, (int)2);
    private static final Map<class_2350, class_265> CAMERA_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)class_2350.field_11043, (Object)class_2248.method_9541((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)12.0, (double)16.0), (Object)class_2350.field_11035, (Object)class_2248.method_9541((double)5.0, (double)2.0, (double)0.0, (double)11.0, (double)12.0, (double)11.0), (Object)class_2350.field_11039, (Object)class_2248.method_9541((double)5.0, (double)2.0, (double)5.0, (double)16.0, (double)12.0, (double)11.0), (Object)class_2350.field_11034, (Object)class_2248.method_9541((double)0.0, (double)2.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0)));
    private static final Map<class_2350, class_265> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)class_2350.field_11043, (Object)class_259.method_1084((class_265)class_2248.method_9541((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)7.0, (double)16.0), (class_265)class_2248.method_9541((double)5.0, (double)7.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0)), (Object)class_2350.field_11035, (Object)class_259.method_1084((class_265)class_2248.method_9541((double)5.0, (double)2.0, (double)0.0, (double)11.0, (double)7.0, (double)11.0), (class_265)class_2248.method_9541((double)5.0, (double)7.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0)), (Object)class_2350.field_11039, (Object)class_259.method_1084((class_265)class_2248.method_9541((double)5.0, (double)2.0, (double)5.0, (double)16.0, (double)7.0, (double)11.0), (class_265)class_2248.method_9541((double)5.0, (double)7.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0)), (Object)class_2350.field_11034, (Object)class_259.method_1084((class_265)class_2248.method_9541((double)0.0, (double)2.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0), (class_265)class_2248.method_9541((double)5.0, (double)7.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0))));
    private final boolean emitsParticles;
    private final String PlaceabletooltipLetter;
    private static final Set<class_2248> SOUL_WAX_SUPPORT_BLOCKS = Set.of(AllBlocks.SOUL_OAK_LOG, AllBlocks.SOUL_OAK_WOOD, AllBlocks.STRIPPED_SOUL_OAK_LOG, AllBlocks.STRIPPED_SOUL_OAK_WOOD);

    public SoulOakBranchBlock(boolean emitsParticles, String placeabletooltipLetter, class_4970.class_2251 settings) {
        super(settings.method_9631(state -> (Boolean)state.method_11654((class_2769)LIT) != false ? 1 : 0).method_9640());
        this.emitsParticles = emitsParticles;
        this.PlaceabletooltipLetter = placeabletooltipLetter;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUL_WAX_STAGE, (Comparable)Integer.valueOf(0)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, WATERLOGGED, LIT, SOUL_WAX_STAGE});
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SoulOakBranchBlock.getCameraShape(state);
    }

    public static class_265 getCameraShape(class_2680 state) {
        return CAMERA_SHAPES.get(state.method_11654((class_2769)FACING));
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SoulOakBranchBlock.getShape(state);
    }

    public static class_265 getShape(class_2680 state) {
        return SHAPES.get(state.method_11654((class_2769)FACING));
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        int stage;
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            if ((Integer)state.method_11654((class_2769)SOUL_WAX_STAGE) != 0) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)SOUL_WAX_STAGE, (Comparable)Integer.valueOf(0)), 2);
            }
            return;
        }
        if (!((Boolean)state.method_11654((class_2769)LIT)).booleanValue()) {
            return;
        }
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        class_2338 supportPos = pos.method_10093(facing.method_10153());
        class_2680 supportState = world.method_8320(supportPos);
        if (SOUL_WAX_SUPPORT_BLOCKS.contains(supportState.method_26204()) && (stage = ((Integer)state.method_11654((class_2769)SOUL_WAX_STAGE)).intValue()) < 2 && random.method_43048(15) == 0) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)SOUL_WAX_STAGE, (Comparable)Integer.valueOf(stage + 1)), 2);
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 held = player.method_5998(hand);
        if ((Integer)state.method_11654((class_2769)SOUL_WAX_STAGE) == 2 && held.method_7909() instanceof class_1820) {
            if (!world.field_9236) {
                class_1799 dropStack = new class_1799((class_1935)AllItems.SOUL_WAX, 1);
                class_1542 itemEntity = new class_1542(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.75, (double)pos.method_10260() + 0.5, dropStack);
                itemEntity.method_18800(0.0, 0.1, 0.0);
                world.method_8649((class_1297)itemEntity);
                held.method_7956(1, (class_1309)player, p -> p.method_20236(hand));
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)SOUL_WAX_STAGE, (Comparable)Integer.valueOf(0)), 2);
                world.method_8396(null, pos, class_3417.field_14975, class_3419.field_15245, 1.0f, 0.9f);
            }
            return class_1269.field_5812;
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    public static boolean isLitInRange(class_1937 world, class_2338 pos) {
        for (int i = 1; i <= 5; ++i) {
            class_2338 blockPos = pos.method_10087(i);
            class_2680 blockState = world.method_8320(blockPos);
            if (!SoulOakBranchBlock.isLit(blockState)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLit(class_2680 state) {
        return state.method_28498((class_2769)LIT) && state.method_26164(ModTags.SOUL_OAK_LITABLE) && (Boolean)state.method_11654((class_2769)LIT) != false;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue() && (Integer)state.method_11654((class_2769)SOUL_WAX_STAGE) != 0) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)SOUL_WAX_STAGE, (Comparable)Integer.valueOf(0)), 2);
        }
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
            if ((Integer)state.method_11654((class_2769)SOUL_WAX_STAGE) != 0 && world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                serverWorld.method_8652(pos, (class_2680)state.method_11657((class_2769)SOUL_WAX_STAGE, (Comparable)Integer.valueOf(0)), 3);
            }
        }
        if (direction.method_10153() == state.method_11654((class_2769)FACING) && !state.method_26184((class_4538)world, pos)) {
            return class_2246.field_10124.method_9564();
        }
        return state;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        class_2338 blockPos = pos.method_10093(direction.method_10153());
        class_2680 blockState = world.method_8320(blockPos);
        return blockState.method_26206((class_1922)world, blockPos, direction);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2338 pos = ctx.method_8037();
        class_1937 world = ctx.method_8045();
        class_3610 fluidState = world.method_8316(pos);
        class_2680 blockState = this.method_9564();
        for (class_2350 direction : ctx.method_7718()) {
            class_2350 opposite;
            if (!direction.method_10166().method_10179() || !(blockState = (class_2680)blockState.method_11657((class_2769)FACING, (Comparable)(opposite = direction.method_10153()))).method_26184((class_4538)world, pos)) continue;
            boolean isWater = fluidState.method_15772() == class_3612.field_15910;
            return (class_2680)((class_2680)blockState.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(isWater))).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false));
        }
        return null;
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        block2: {
            block3: {
                if (!this.emitsParticles || !((Boolean)state.method_11654((class_2769)LIT)).booleanValue()) break block2;
                if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue() || random.method_43048(3) != 0) break block3;
                for (int i = 0; i < random.method_43048(2) + 2; ++i) {
                    double x = (double)pos.method_10263() + 0.5;
                    double y = (double)pos.method_10264() + 0.75;
                    double z = (double)pos.method_10260() + 0.5;
                    double velocityX = random.method_43059() * 0.002;
                    double velocityY = 0.002;
                    double velocityZ = random.method_43059() * 0.002;
                    world.method_8406((class_2394)AllParticles.SOUL_OAK_COSY_SMOKE, x, y, z, velocityX, velocityY, velocityZ);
                }
                break block2;
            }
            if (!this.emitsParticles || !((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue() || random.method_43048(3) != 0) break block2;
            for (int i = 0; i < random.method_43048(2) + 2; ++i) {
                double x = (double)pos.method_10263() + 0.5;
                double y = (double)pos.method_10264() + 0.75;
                double z = (double)pos.method_10260() + 0.5;
                double velocityX = random.method_43059() * 0.002;
                double velocityY = random.method_43059() * 0.02;
                double velocityZ = random.method_43059() * 0.002;
                world.method_8406((class_2394)class_2398.field_11247, x, y, z, velocityX, velocityY, velocityZ);
            }
        }
    }

    public static boolean canBeLit(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)LIT) == false;
    }

    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return false;
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        class_1799 stack = super.method_9574(world, pos, state);
        int soulWaxStage = (Integer)state.method_11654((class_2769)SOUL_WAX_STAGE);
        if (soulWaxStage > 0) {
            class_2487 nbt = stack.method_7948();
            nbt.method_10569("SoulWaxStage", soulWaxStage);
            nbt.method_10569("CustomModelData", soulWaxStage);
        }
        return stack;
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        List drops = super.method_9560(state, builder);
        if (!drops.isEmpty()) {
            class_1799 drop = (class_1799)drops.get(0);
            int soulWaxStage = (Integer)state.method_11654((class_2769)SOUL_WAX_STAGE);
            if (soulWaxStage > 0) {
                class_2487 nbt = drop.method_7948();
                nbt.method_10569("SoulWaxStage", soulWaxStage);
                nbt.method_10569("CustomModelData", soulWaxStage);
            }
        }
        return drops;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        class_2487 nbt;
        if (stack.method_7985() && (nbt = stack.method_7969()) != null && nbt.method_10545("SoulWaxStage")) {
            int stage = nbt.method_10550("SoulWaxStage");
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)SOUL_WAX_STAGE, (Comparable)Integer.valueOf(stage)), 3);
        }
        super.method_9567(world, pos, state, placer, stack);
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 context) {
        if (class_437.method_25442()) {
            class_2487 nbt;
            boolean hasSoulWaxInfo = false;
            if (stack.method_7985() && (nbt = stack.method_7969()) != null && nbt.method_10545("SoulWaxStage")) {
                int soulWaxStage = nbt.method_10550("SoulWaxStage");
                if (soulWaxStage == 1) {
                    tooltip.add((class_2561)class_2561.method_43470((String)"Soul Wax Stage: [Growing]").method_27692(class_124.field_1080));
                    hasSoulWaxInfo = true;
                } else if (soulWaxStage == 2) {
                    tooltip.add((class_2561)class_2561.method_43470((String)"Soul Wax Stage: [Fully Grown]").method_27692(class_124.field_1080));
                    hasSoulWaxInfo = true;
                }
            }
            if (hasSoulWaxInfo) {
                tooltip.add((class_2561)class_2561.method_43470((String)""));
            }
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.lit_tooltip").method_27692(class_124.field_1068));
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.place_wall").method_27692(class_124.field_1068));
            tooltip.add((class_2561)class_2561.method_43470((String)"").method_27692(class_124.field_1068));
            tooltip.addAll(this.wrapText(class_2561.method_43471((String)"tooltip.soul_wax_branch_info").getString(), 35));
        } else {
            class_2487 nbt;
            tooltip.add((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)this.PlaceabletooltipLetter).method_27694(style -> style.method_36139(class_124.field_1068.method_532().intValue()).method_27704(new class_2960("chris_s_additions", "placeable_tooltip_font")))));
            boolean hasSoulWaxInfo = false;
            if (stack.method_7985() && (nbt = stack.method_7969()) != null && nbt.method_10545("SoulWaxStage")) {
                int soulWaxStage = nbt.method_10550("SoulWaxStage");
                if (soulWaxStage == 1) {
                    tooltip.add((class_2561)class_2561.method_43470((String)"Soul Wax Stage: [Growing]").method_27692(class_124.field_1080));
                    hasSoulWaxInfo = true;
                } else if (soulWaxStage == 2) {
                    tooltip.add((class_2561)class_2561.method_43470((String)"Soul Wax Stage: [Fully Grown]").method_27692(class_124.field_1080));
                    hasSoulWaxInfo = true;
                }
            }
            if (hasSoulWaxInfo) {
                tooltip.add((class_2561)class_2561.method_43470((String)""));
            }
            tooltip.add((class_2561)class_2561.method_43470((String)"Hold \u00a7e[SHIFT]\u00a7r for more info").method_27692(class_124.field_1080));
        }
    }

    private List<class_2561> wrapText(String text, int maxLength) {
        ArrayList<class_2561> wrappedLines = new ArrayList<class_2561>();
        String[] words = text.split(" ");
        StringBuilder line = new StringBuilder();
        for (String word : words) {
            if (line.length() + word.length() > maxLength) {
                wrappedLines.add((class_2561)class_2561.method_43470((String)line.toString()).method_27692(class_124.field_1068));
                line = new StringBuilder();
            }
            line.append(word).append(" ");
        }
        if (!line.isEmpty()) {
            wrappedLines.add((class_2561)class_2561.method_43470((String)line.toString()).method_27692(class_124.field_1068));
        }
        return wrappedLines;
    }
}

