/*
 * Decompiled with CFR 0.152.
 */
package net.chris.chris_s_additions.item.custom.costumes;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.chris.chris_s_additions.item.client.cosmetic.ChestHeadCostumeRenderer;
import net.chris.chris_s_additions.item.custom.UnenchantableArmorItem;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_572;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.RenderProvider;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class ChestHeadCostumeItem
extends UnenchantableArmorItem
implements GeoItem {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);
    private final String cosmeticTooltipLetter;
    private static final RawAnimation OPENING_ANIM = RawAnimation.begin().thenPlayAndHold("opening");
    private static final RawAnimation CLOSING_ANIM = RawAnimation.begin().thenPlayAndHold("closing");

    public ChestHeadCostumeItem(class_1741 material, class_1738.class_8051 type, String cosmeticTooltipLetter, class_1792.class_1793 settings) {
        super(material, type, "G", settings);
        this.cosmeticTooltipLetter = cosmeticTooltipLetter;
    }

    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private ChestHeadCostumeRenderer renderer;

            public class_572<class_1309> getHumanoidArmorModel(class_1309 livingEntity, class_1799 itemStack, class_1304 equipmentSlot, class_572<class_1309> original) {
                if (this.renderer == null) {
                    this.renderer = new ChestHeadCostumeRenderer();
                }
                this.renderer.prepForRender((class_1297)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller_normal", 2, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller_armor_stand", 0, this::armorStandPredicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> state) {
        class_1309 entity = (class_1309)state.getData(DataTickets.ENTITY);
        if (entity == null || entity.method_5864().method_5882().contains("armor_stand")) {
            return PlayState.STOP;
        }
        boolean shouldCrouch = entity.method_5715();
        RawAnimation target = shouldCrouch ? CLOSING_ANIM : OPENING_ANIM;
        AnimationController controller = state.getController();
        if (controller.getCurrentRawAnimation() != target) {
            controller.setAnimation(target);
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState armorStandPredicate(AnimationState<T> state) {
        class_1309 entity = (class_1309)state.getData(DataTickets.ENTITY);
        if (entity == null || !entity.method_5864().method_5882().contains("armor_stand")) {
            return PlayState.STOP;
        }
        class_1799 stack = (class_1799)state.getData(DataTickets.ITEMSTACK);
        boolean shouldCrouch = stack.method_7985() && stack.method_7969().method_10577("sneakPlaced");
        RawAnimation target = shouldCrouch ? CLOSING_ANIM : OPENING_ANIM;
        AnimationController controller = state.getController();
        controller.forceAnimationReset();
        controller.setAnimation(target);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

