/*
 * Decompiled with CFR 0.152.
 */
package net.chris.chris_s_additions.item.custom.costumes;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.chris.chris_s_additions.item.client.cosmetic.ScarfRenderer;
import net.chris.chris_s_additions.item.custom.enums.ScarfVariant;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1706;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_471;
import net.minecraft.class_572;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.RenderProvider;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class ScarfItem
extends class_1738
implements GeoItem {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);
    private final ScarfVariant variant;
    private final String cosmeticTooltipLetter;

    public ScarfItem(class_1741 material, class_1738.class_8051 type, String cosmeticTooltipLetter, class_1792.class_1793 settings, ScarfVariant variant) {
        super(material, type, settings);
        this.cosmeticTooltipLetter = cosmeticTooltipLetter;
        this.variant = variant;
    }

    public ScarfVariant getVariant() {
        return this.variant;
    }

    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private ScarfRenderer renderer;

            public class_572<class_1309> getHumanoidArmorModel(class_1309 livingEntity, class_1799 itemStack, class_1304 equipmentSlot, class_572<class_1309> original) {
                if (this.renderer == null) {
                    this.renderer = new ScarfRenderer();
                }
                this.renderer.prepForRender((class_1297)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState animationState) {
        animationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }

    public int method_7837() {
        return 0;
    }

    public boolean method_7846() {
        return false;
    }

    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return false;
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return ImmutableMultimap.of();
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);
        this.removeEnchantments(stack);
    }

    public void method_7843(class_1799 stack, class_1937 world, class_1657 player) {
        super.method_7843(stack, world, player);
        this.removeEnchantments(stack);
    }

    public void method_7860(class_2487 nbt) {
        super.method_7860(nbt);
        if (nbt.method_10545("Enchantments")) {
            nbt.method_10551("Enchantments");
        }
        if (nbt.method_10545("StoredEnchantments")) {
            nbt.method_10551("StoredEnchantments");
        }
    }

    private void removeEnchantments(class_1799 stack) {
        if (stack.method_7942()) {
            stack.method_7948().method_10551("Enchantments");
        }
        if (stack.method_7948().method_10545("StoredEnchantments")) {
            stack.method_7948().method_10551("StoredEnchantments");
        }
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        class_437 currentScreen;
        tooltip.add((class_2561)class_2561.method_43470((String)this.cosmeticTooltipLetter).method_27694(style -> style.method_36139(class_124.field_1068.method_532().intValue()).method_27704(new class_2960("chris_s_additions", "cosmetic_tooltip_font"))));
        boolean showAnvilWarning = false;
        if (world != null && world.field_9236 && (currentScreen = class_310.method_1551().field_1755) instanceof class_471) {
            class_471 anvilScreen = (class_471)currentScreen;
            class_1799 inputLeft = ((class_1706)anvilScreen.method_17577()).method_7611(0).method_7677();
            class_1799 inputRight = ((class_1706)anvilScreen.method_17577()).method_7611(1).method_7677();
            class_1799 output = ((class_1706)anvilScreen.method_17577()).method_7611(2).method_7677();
            if (stack == inputLeft || stack == inputRight || stack == output) {
                showAnvilWarning = true;
                tooltip.addAll(this.wrapText("You can't apply enchantments to this item!"));
            }
        }
        if (!showAnvilWarning) {
            tooltip.add(this.getSlotTooltip());
        }
    }

    private List<class_2561> wrapText(String text) {
        ArrayList<class_2561> wrappedLines = new ArrayList<class_2561>();
        String[] words = text.split(" ");
        StringBuilder line = new StringBuilder();
        for (String word : words) {
            if (line.length() + word.length() > 30) {
                wrappedLines.add((class_2561)class_2561.method_43470((String)line.toString()).method_27692(class_124.field_1061));
                line = new StringBuilder();
            }
            line.append(word).append(" ");
        }
        if (!line.isEmpty()) {
            wrappedLines.add((class_2561)class_2561.method_43470((String)line.toString()).method_27692(class_124.field_1061));
        }
        return wrappedLines;
    }

    private class_2561 getSlotTooltip() {
        return switch (this.field_41933) {
            default -> throw new IncompatibleClassChangeError();
            case class_1738.class_8051.field_41934 -> class_2561.method_43470((String)"Slot: Head").method_27692(class_124.field_1080);
            case class_1738.class_8051.field_41935 -> class_2561.method_43470((String)"Slot: Body").method_27692(class_124.field_1080);
            case class_1738.class_8051.field_41936 -> class_2561.method_43470((String)"Slot: Legs").method_27692(class_124.field_1080);
            case class_1738.class_8051.field_41937 -> class_2561.method_43470((String)"Slot: Feet").method_27692(class_124.field_1080);
        };
    }
}

