#version 150

uniform sampler2D DiffuseSampler;
uniform sampler2D DepthSampler;
uniform float DepthDarkenStrength;

in vec2 texCoord;
out vec4 fragColor;

void main() {
    vec4 color = texture(DiffuseSampler, texCoord);

    float depth = texture(DepthSampler, texCoord).r;
    // Farther = darker, Closer = brighter
    float factor = 1.0 - depth * DepthDarkenStrength;

    fragColor = vec4(color.rgb * factor, color.a);
}
