/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core;

import dev.toma.configuration.Configuration;
import net.minecraft.resources.Identifier;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import tnt.tarkovcraft.core.common.TarkovCraftCoreEventHandler;
import tnt.tarkovcraft.core.common.config.TarkovCraftCoreConfig;
import tnt.tarkovcraft.core.common.init.CoreAttributeModifiers;
import tnt.tarkovcraft.core.common.init.CoreAttributes;
import tnt.tarkovcraft.core.common.init.CoreDataAttachments;
import tnt.tarkovcraft.core.common.init.CoreItemDataComponents;
import tnt.tarkovcraft.core.common.init.CoreItemStackFilters;
import tnt.tarkovcraft.core.common.init.CoreNumberProviders;
import tnt.tarkovcraft.core.common.init.CoreRegistries;
import tnt.tarkovcraft.core.common.init.CoreSkillStatConditions;
import tnt.tarkovcraft.core.common.init.CoreSkillStats;
import tnt.tarkovcraft.core.common.init.CoreSkillTrackers;
import tnt.tarkovcraft.core.common.init.CoreSkillTriggerConditions;
import tnt.tarkovcraft.core.common.init.CoreSkillTriggerEvents;
import tnt.tarkovcraft.core.common.init.CoreStatistics;
import tnt.tarkovcraft.core.common.skill.SkillDefinition;
import tnt.tarkovcraft.core.common.skill.SkillSystem;
import tnt.tarkovcraft.core.common.statistic.DisplayStatistic;
import tnt.tarkovcraft.core.common.weight.WeightSystem;
import tnt.tarkovcraft.core.network.TarkovCraftCoreNetwork;

@Mod(value="tarkovcraft_core")
public final class TarkovCraftCore {
    public static final String MOD_ID = "tarkovcraft_core";
    public static final String GLOBAL_CATEGORY_KEY = "category.tarkovcraft";
    public static final Logger LOGGER = LogManager.getLogger((String)"TarkovCraftCore");
    public static final Marker MARKER = MarkerManager.getMarker((String)"Core");
    private static TarkovCraftCoreConfig config;

    public TarkovCraftCore(IEventBus modEventBus, ModContainer container) {
        config = (TarkovCraftCoreConfig)Configuration.registerSimpleYmlConfig(TarkovCraftCoreConfig.class);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::registerCustomRegistries);
        modEventBus.addListener(this::registerCustomDatapackRegistries);
        modEventBus.addListener(TarkovCraftCoreNetwork::onRegistration);
        modEventBus.addListener(WeightSystem.INSTANCE::registerDefaultProviders);
        NeoForge.EVENT_BUS.register((Object)new TarkovCraftCoreEventHandler());
        NeoForge.EVENT_BUS.addListener(SkillSystem::onServerStarted);
        CoreAttributes.REGISTRY.register(modEventBus);
        CoreAttributeModifiers.REGISTRY.register(modEventBus);
        CoreItemStackFilters.REGISTRY.register(modEventBus);
        CoreNumberProviders.REGISTRY.register(modEventBus);
        CoreDataAttachments.REGISTRY.register(modEventBus);
        CoreItemDataComponents.REGISTRY.register(modEventBus);
        CoreSkillTriggerEvents.REGISTRY.register(modEventBus);
        CoreSkillTrackers.REGISTRY.register(modEventBus);
        CoreSkillTriggerConditions.REGISTRY.register(modEventBus);
        CoreSkillStatConditions.REGISTRY.register(modEventBus);
        CoreSkillStats.REGISTRY.register(modEventBus);
        CoreStatistics.REGISTRY.register(modEventBus);
    }

    public static TarkovCraftCoreConfig getConfig() {
        return config;
    }

    public static Identifier createIdentifier(String path) {
        return Identifier.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    private void registerCustomRegistries(NewRegistryEvent event) {
        event.register(CoreRegistries.ATTRIBUTE);
        event.register(CoreRegistries.ATTRIBUTE_MODIFIER);
        event.register(CoreRegistries.ITEMSTACK_FILTER);
        event.register(CoreRegistries.NUMBER_PROVIDER);
        event.register(CoreRegistries.STATISTICS);
        event.register(CoreRegistries.CURRENCY);
        event.register(CoreRegistries.SKILL_TRIGGER_EVENT);
        event.register(CoreRegistries.SKILL_TRIGGER_TYPE);
        event.register(CoreRegistries.SKILL_TRIGGER_CONDITION_TYPE);
        event.register(CoreRegistries.SKILL_STAT_CONDITION_TYPE);
        event.register(CoreRegistries.SKILL_STAT);
    }

    private void registerCustomDatapackRegistries(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(CoreRegistries.DatapackKeys.SKILL_DEFINITION, SkillDefinition.DIRECT_CODEC, SkillDefinition.DIRECT_CODEC);
        event.dataPackRegistry(CoreRegistries.DatapackKeys.DISPLAY_STATISTIC, DisplayStatistic.CODEC, DisplayStatistic.CODEC);
    }

    private void setup(FMLCommonSetupEvent event) {
        WeightSystem.INSTANCE.init();
    }
}

