/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.client.screen.widget;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;

public abstract class ContainerWidget
extends AbstractWidget
implements ContainerEventHandler {
    private final List<Renderable> renderables = new ArrayList<Renderable>();
    private final List<GuiEventListener> children = new ArrayList<GuiEventListener>();
    private final List<NarratableEntry> narratables = new ArrayList<NarratableEntry>();
    private boolean isDragging;
    private GuiEventListener focused;

    public ContainerWidget(int x, int y, int width, int height, Component title) {
        super(x, y, width, height, title);
    }

    public <T extends Renderable> T addRenderableOnly(T renderable) {
        this.renderables.add(renderable);
        return renderable;
    }

    public <T extends GuiEventListener & NarratableEntry> T addWidget(T listener) {
        this.children.add(listener);
        this.narratables.add(listener);
        return listener;
    }

    public <T extends GuiEventListener & NarratableEntry> T addRenderableWidget(T widget) {
        this.renderables.add((Renderable)widget);
        return this.addWidget(widget);
    }

    public void removeWidget(GuiEventListener listener) {
        if (listener instanceof Renderable) {
            this.renderables.remove(listener);
        }
        if (listener instanceof NarratableEntry) {
            this.narratables.remove(listener);
        }
        this.children.remove(listener);
    }

    public void clearWidgets() {
        this.renderables.clear();
        this.children.clear();
        this.narratables.clear();
    }

    public List<? extends GuiEventListener> children() {
        return this.children;
    }

    public boolean isFocused() {
        return super.isFocused();
    }

    public void setFocused(boolean focused) {
        super.setFocused(focused);
    }

    public final boolean isDragging() {
        return this.isDragging;
    }

    public final void setDragging(boolean p_313698_) {
        this.isDragging = p_313698_;
    }

    @Nullable
    public GuiEventListener getFocused() {
        return this.focused;
    }

    public void setFocused(@Nullable GuiEventListener eventListener) {
        if (this.focused != null) {
            this.focused.setFocused(false);
        }
        if (eventListener != null) {
            eventListener.setFocused(true);
        }
        this.focused = eventListener;
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent navigationEvent) {
        return super.nextFocusPath(navigationEvent);
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
        return super.mouseClicked(event, isDoubleClick);
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        super.mouseReleased(event);
        return super.mouseReleased(event);
    }

    public boolean mouseDragged(MouseButtonEvent event, double mouseX, double mouseY) {
        super.mouseDragged(event, mouseX, mouseY);
        return super.mouseDragged(event, mouseX, mouseY);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }
}

