/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.data.number;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.resources.Identifier;
import tnt.tarkovcraft.core.common.data.duration.Duration;
import tnt.tarkovcraft.core.common.data.number.ConstantNumberProvider;
import tnt.tarkovcraft.core.common.data.number.DurationNumberProvider;
import tnt.tarkovcraft.core.common.data.number.NumberProvider;
import tnt.tarkovcraft.core.common.init.CoreRegistries;

public record NumberProviderType<N extends NumberProvider>(Identifier identifier, MapCodec<N> codec) {
    public static final Codec<NumberProvider> ID_CODEC = CoreRegistries.NUMBER_PROVIDER.byNameCodec().dispatch(NumberProvider::getType, NumberProviderType::codec);

    public static <N extends Number> NumberProvider resolve(Either<NumberProvider, Either<Duration, N>> either) {
        return (NumberProvider)either.map(Function.identity(), nested -> (NumberProvider)nested.map(DurationNumberProvider::new, num -> new ConstantNumberProvider(num.doubleValue())));
    }

    public static <N extends Number> NumberProvider resolveNoDuration(Either<NumberProvider, N> either) {
        return (NumberProvider)either.map(Function.identity(), num -> new ConstantNumberProvider(num.doubleValue()));
    }

    public static <N extends Number> Codec<Either<NumberProvider, Either<Duration, N>>> complexCodec(Codec<N> numberCodec) {
        return Codec.either(ID_CODEC, (Codec)Codec.either(Duration.STRING_CODEC, numberCodec));
    }

    public static <N extends Number> Codec<Either<NumberProvider, N>> complexCodecNoDuration(Codec<N> numberCodec) {
        return Codec.either(ID_CODEC, numberCodec);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof NumberProviderType)) {
            return false;
        }
        NumberProviderType that = (NumberProviderType)o;
        return Objects.equals(this.identifier, that.identifier);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.identifier);
    }
}

