/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import dev.toma.configuration.ConfigurationOptions;
import dev.toma.configuration.TestingConfig;
import dev.toma.configuration.config.Config;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.ConfigValueLocation;
import dev.toma.configuration.config.format.ConfigFormats;
import dev.toma.configuration.config.format.IConfigFormatHandler;
import dev.toma.configuration.config.io.ConfigurationFileManager;
import dev.toma.configuration.config.value.IConfigValue;
import dev.toma.configuration.service.ServiceHelper;
import dev.toma.configuration.service.services.Platform;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

public final class Configuration {
    public static final String MODID = "configuration";
    @ApiStatus.Internal
    public static final Logger LOGGER = LogManager.getLogger((String)"Configuration");
    @ApiStatus.Internal
    public static final Platform PLATFORM = ServiceHelper.loadService(Platform.class);
    @ApiStatus.Internal
    public static ConfigHolder<ConfigurationOptions> options;
    public static final Codec<ConfigHolder<?>> BY_ID_CODEC;

    @ApiStatus.Internal
    public static void setup() {
        if (PLATFORM.isDevelopmentEnvironment()) {
            Configuration.registerSimpleYmlConfig(TestingConfig.class);
        }
        options = Configuration.registerIniConfig(ConfigurationOptions.class);
    }

    public static <CFG> ConfigHolder<CFG> registerConfig(Class<CFG> cfgClass, IConfigFormatHandler formatFactory) {
        String group;
        Config cfg = cfgClass.getAnnotation(Config.class);
        if (cfg == null) {
            throw new IllegalArgumentException("Config class must be annotated with '@Config' annotation");
        }
        String id = cfg.id();
        String filename = cfg.filename();
        if (filename.isEmpty()) {
            filename = id;
        }
        if ((group = cfg.group()).isEmpty()) {
            group = id;
        }
        ConfigHolder<CFG> holder = new ConfigHolder<CFG>(cfgClass, id, filename, group, cfg.unifiedfolder(), formatFactory);
        ConfigHolder.registerConfig(holder);
        if (cfgClass.getAnnotation(Config.NoAutoSync.class) == null) {
            ConfigurationFileManager.FILE_WATCH_MANAGER.addTrackedConfig(holder);
        }
        return holder;
    }

    public static <CFG> CFG registerSimpleConfig(Class<CFG> cfgClass, IConfigFormatHandler formatFactory) {
        return Configuration.registerConfig(cfgClass, formatFactory).getConfigInstance();
    }

    public static <CFG> ConfigHolder<CFG> registerJsonConfig(Class<CFG> cfgClass) {
        return Configuration.registerConfig(cfgClass, ConfigFormats.JSON);
    }

    public static <CFG> CFG registerSimpleJsonConfig(Class<CFG> cfgClass) {
        return Configuration.registerJsonConfig(cfgClass).getConfigInstance();
    }

    public static <CFG> ConfigHolder<CFG> registerPropertiesConfig(Class<CFG> cfgClass) {
        return Configuration.registerConfig(cfgClass, ConfigFormats.PROPERTIES);
    }

    public static <CFG> CFG registerSimplePropertiesConfig(Class<CFG> cfgClass) {
        return Configuration.registerPropertiesConfig(cfgClass).getConfigInstance();
    }

    public static <CFG> ConfigHolder<CFG> registerYmlConfig(Class<CFG> cfgClass) {
        return Configuration.registerConfig(cfgClass, ConfigFormats.YML);
    }

    public static <CFG> CFG registerSimpleYmlConfig(Class<CFG> cfgClass) {
        return Configuration.registerYmlConfig(cfgClass).getConfigInstance();
    }

    public static <CFG> ConfigHolder<CFG> registerIniConfig(Class<CFG> cfgClass) {
        return Configuration.registerConfig(cfgClass, ConfigFormats.INI);
    }

    public static <CFG> CFG registerSimpleIniConfig(Class<CFG> cfgClass) {
        return Configuration.registerIniConfig(cfgClass).getConfigInstance();
    }

    public static <CFG> Optional<ConfigHolder<CFG>> getConfig(String id) {
        return ConfigHolder.getConfig(id);
    }

    public static <V> Optional<IConfigValue<V>> getConfigValueHolder(ConfigValueLocation location, Class<V> type) {
        ConfigHolder holder = Configuration.getConfig(location.namespace()).orElse(null);
        if (holder == null) {
            return Optional.empty();
        }
        return holder.getConfigValue(location.path(), type);
    }

    public static <V> Optional<V> getConfigValue(ConfigValueLocation location, Class<V> type) {
        ConfigHolder holder = Configuration.getConfig(location.namespace()).orElse(null);
        if (holder == null) {
            return Optional.empty();
        }
        return holder.getValue(location.path(), type);
    }

    static {
        BY_ID_CODEC = Codec.STRING.comapFlatMap(id -> {
            Optional optional = Configuration.getConfig(id);
            return optional.map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown config ID '" + id + "'"));
        }, ConfigHolder::getConfigId);
    }
}

