/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.screen;

import dev.toma.configuration.Configuration;
import dev.toma.configuration.client.ConfigurationClient;
import dev.toma.configuration.client.screen.ConfigSettingsScreen;
import dev.toma.configuration.client.screen.DialogScreen;
import dev.toma.configuration.client.theme.ConfigTheme;
import dev.toma.configuration.client.widget.ConfigEntryWidget;
import dev.toma.configuration.client.widget.ThemedButtonWidget;
import dev.toma.configuration.client.widget.render.TextureRenderer;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.io.ConfigurationFileManager;
import dev.toma.configuration.config.validate.ValidationResult;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.ObjectValue;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public abstract class AbstractConfigScreen
extends Screen
implements ConfigEntryWidget.IValidationRenderer {
    public static final int HEADER_HEIGHT = 35;
    public static final int FOOTER_HEIGHT = 30;
    public static final WidgetSprites BUTTON_SPRITES = new WidgetSprites(Identifier.withDefaultNamespace((String)"widget/button"), Identifier.withDefaultNamespace((String)"widget/button_disabled"), Identifier.withDefaultNamespace((String)"widget/button_highlighted"));
    public static final Marker MARKER = MarkerManager.getMarker((String)"Screen");
    public static final Component LABEL_BACK = Component.translatable((String)"text.configuration.value.back");
    public static final Component LABEL_SAVE_AND_CLOSE = Component.translatable((String)"text.configuration.value.save_and_close");
    public static final Identifier ICON_REVERT = Identifier.fromNamespaceAndPath((String)"configuration", (String)"textures/icons/revert.png");
    public static final Identifier ICON_REVERT_DEFAULT = Identifier.fromNamespaceAndPath((String)"configuration", (String)"textures/icons/revert_default.png");
    public static final Identifier ICON_APPLY = Identifier.fromNamespaceAndPath((String)"configuration", (String)"textures/icons/apply.png");
    protected final ConfigHolder<?> holder;
    protected final ConfigTheme theme;
    protected final Screen last;
    protected int index;
    protected int pageSize;
    private ThemedButtonWidget applyButton;
    private ThemedButtonWidget revertButton;
    private ThemedButtonWidget revertDefaultButton;
    private DeferredDescription deferredDescription;

    public AbstractConfigScreen(Component title, Screen previous, ConfigHolder<?> configHolder) {
        super(title);
        this.holder = configHolder;
        this.theme = ConfigurationClient.getConfigTheme(configHolder);
        this.last = previous;
    }

    public String getConfigId() {
        return this.holder.getConfigId();
    }

    public void onClose() {
        super.onClose();
        this.saveConfig(true);
    }

    public static void renderScrollbar(GuiGraphics graphics, int x, int y, int width, int height, int index, int valueCount, int paging, int bgColor) {
        if (valueCount <= paging) {
            return;
        }
        double step = (double)height / (double)valueCount;
        int min = Mth.floor((double)((double)index * step));
        int max = Mth.ceil((double)((double)(index + paging) * step));
        int y1 = y + min;
        int y2 = y + max;
        graphics.fill(x, y, x + width, y + height, bgColor);
        graphics.fill(x, y1, x + width, y2, -7829368);
        graphics.fill(x, y1, x + width - 1, y2 - 1, -1118482);
        graphics.fill(x + 1, y1 + 1, x + width - 1, y2 - 1, -3355444);
    }

    protected void addSettingsButton() {
        ThemedButtonWidget settings = (ThemedButtonWidget)this.addRenderableWidget((GuiEventListener)new ThemedButtonWidget(this.width - 25, 5, 20, 20, (Component)Component.literal((String)"..."), this.theme));
        settings.setBackgroundRenderer(this.theme.getButtonBackground(settings));
        settings.setClickListener((widget, mouseX, mouseY) -> {
            ConfigSettingsScreen settingsScreen = new ConfigSettingsScreen(this);
            this.minecraft.setScreen((Screen)settingsScreen);
        });
        settings.setTooltip(Tooltip.create((Component)Component.translatable((String)"options.title")));
        settings.setTooltipDelay(Duration.ofMillis(300L));
    }

    protected void addFooter() {
        int centerY = this.height - 30 + 5;
        Component backLabel = this.isRoot() ? LABEL_SAVE_AND_CLOSE : LABEL_BACK;
        ThemedButtonWidget backButton = (ThemedButtonWidget)this.addRenderableWidget((GuiEventListener)new ThemedButtonWidget(5, centerY, 120, 20, backLabel, this.theme));
        backButton.setBackgroundRenderer(this.theme.getButtonBackground(backButton));
        backButton.setClickListener((widget, mouseX, mouseY) -> this.buttonBackClicked());
        this.applyButton = (ThemedButtonWidget)this.addRenderableWidget((GuiEventListener)new ThemedButtonWidget(this.width - 25, centerY, 20, 20, CommonComponents.EMPTY, this.theme));
        this.applyButton.setBackgroundRenderer(this.theme.getButtonBackground(this.applyButton));
        this.applyButton.setForegroundRenderer(new TextureRenderer(ICON_APPLY, 2, 2, 16, 16));
        this.applyButton.setClickListener((widget, mouseX, mouseY) -> {
            if (this.holder.isChanged()) {
                this.holder.save();
                this.init(this.width, this.height);
            }
        });
        this.applyButton.setTooltip(Tooltip.create((Component)ConfigEntryWidget.APPLY));
        this.applyButton.setTooltipDelay(Duration.ofMillis(300L));
        this.applyButton.active = this.holder.isChanged();
        this.revertDefaultButton = (ThemedButtonWidget)this.addRenderableWidget((GuiEventListener)new ThemedButtonWidget(this.width - 50, centerY, 20, 20, CommonComponents.EMPTY, this.theme));
        this.revertDefaultButton.setBackgroundRenderer(this.theme.getButtonBackground(this.revertDefaultButton));
        this.revertDefaultButton.setForegroundRenderer(new TextureRenderer(ICON_REVERT_DEFAULT, 2, 2, 16, 16));
        this.revertDefaultButton.setClickListener((widget, mouseX, mouseY) -> this.buttonRevertToDefaultClicked());
        this.revertDefaultButton.setTooltip(Tooltip.create((Component)ConfigEntryWidget.REVERT_DEFAULTS));
        this.revertDefaultButton.setTooltipDelay(Duration.ofMillis(300L));
        this.revertDefaultButton.active = this.holder.isChangedFromDefault();
        this.revertButton = (ThemedButtonWidget)this.addRenderableWidget((GuiEventListener)new ThemedButtonWidget(this.width - 75, centerY, 20, 20, CommonComponents.EMPTY, this.theme));
        this.revertButton.setBackgroundRenderer(this.theme.getButtonBackground(this.revertButton));
        this.revertButton.setForegroundRenderer(new TextureRenderer(ICON_REVERT, 2, 2, 16, 16));
        this.revertButton.setClickListener((widget, mouseX, mouseY) -> this.buttonRevertChangesClicked());
        this.revertButton.setTooltip(Tooltip.create((Component)ConfigEntryWidget.REVERT_CHANGES));
        this.revertButton.setTooltipDelay(Duration.ofMillis(300L));
        this.revertButton.active = this.holder.isChanged();
    }

    public void tick() {
        if (this.applyButton != null) {
            this.applyButton.active = this.holder.isChanged();
        }
        if (this.revertDefaultButton != null) {
            this.revertDefaultButton.active = this.holder.isChangedFromDefault();
        }
        if (this.revertButton != null) {
            this.revertButton.active = this.holder.isChanged();
        }
    }

    protected void correctScrollingIndex(int count) {
        if (this.index + this.pageSize > count) {
            this.index = Math.max(count - this.pageSize, 0);
        }
    }

    protected boolean isRoot() {
        return !(this.last instanceof AbstractConfigScreen);
    }

    private void buttonBackClicked() {
        this.minecraft.setScreen(this.last);
        this.saveConfig();
    }

    private void buttonRevertToDefaultClicked() {
        DialogScreen dialog = new DialogScreen(ConfigEntryWidget.REVERT_DEFAULTS, new Component[]{ConfigEntryWidget.REVERT_DEFAULTS_DIALOG_TEXT}, this);
        dialog.onConfirmed(screen -> {
            Configuration.LOGGER.info(MARKER, "Reverting config {} to default values", (Object)this.getConfigId());
            this.revertToDefault(this.holder.values());
            ConfigurationFileManager.saveClientValues(this.holder);
            dialog.displayPreviousScreen();
        });
        this.minecraft.setScreen((Screen)dialog);
    }

    private void buttonRevertChangesClicked() {
        DialogScreen dialog = new DialogScreen(ConfigEntryWidget.REVERT_CHANGES, new Component[]{ConfigEntryWidget.REVERT_CHANGES_DIALOG_TEXT}, this);
        dialog.onConfirmed(screen -> {
            ConfigurationFileManager.reloadClientValues(this.holder);
            dialog.displayPreviousScreen();
        });
        this.minecraft.setScreen((Screen)dialog);
    }

    private void revertToDefault(Collection<ConfigValue<?>> configValues) {
        configValues.forEach(val -> {
            if (val instanceof ObjectValue) {
                ObjectValue objVal = (ObjectValue)val;
                this.revertToDefault(((Map)objVal.get()).values());
            } else if (val.isChangedFromDefault()) {
                val.forceSetDefaultValue();
            }
        });
    }

    private void saveConfig() {
        this.saveConfig(false);
    }

    private void saveConfig(boolean force) {
        if (force || this.isRoot()) {
            ConfigurationFileManager.saveClientValues(this.holder);
        }
    }

    @Override
    public void drawDescription(GuiGraphics graphics, AbstractWidget widget, List<FormattedCharSequence> text, ValidationResult.Type type, int textColor) {
        this.deferredDescription = new DeferredDescription(type, text, textColor, widget.getX() + 5, widget.getY() + widget.getHeight() + 10);
    }

    @Override
    public void drawIcon(GuiGraphics graphics, AbstractWidget widget, ValidationResult.Type type) {
        this.renderValidationIcon(type, graphics, widget, widget.getX() - 22, widget.getY() + 1);
    }

    public void renderValidationIcon(ValidationResult.Type type, GuiGraphics graphics, AbstractWidget widget, int x, int y) {
        Identifier icon = type.iconPath;
        graphics.blit(RenderPipelines.GUI_TEXTURED, icon, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    public static boolean canRenderBackground(Minecraft minecraft) {
        return minecraft.level == null || !Configuration.options.getConfigInstance().hideBackground;
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float renderDelta) {
        if (AbstractConfigScreen.canRenderBackground(this.minecraft)) {
            super.renderBackground(graphics, mouseX, mouseY, renderDelta);
        }
    }

    protected void renderPost(GuiGraphics graphics, float renderDelta) {
        if (this.deferredDescription != null) {
            this.deferredDescription.render(graphics, this.font, this.width, this.height, renderDelta);
            this.deferredDescription = null;
        }
    }

    public record DeferredDescription(ValidationResult.Type type, List<FormattedCharSequence> texts, int textColor, int x, int y) {
        public void render(GuiGraphics graphics, Font font, int width, int height, float renderDelta) {
            if (!this.texts.isEmpty()) {
                int maxTextWidth = 0;
                for (FormattedCharSequence textComponent : this.texts) {
                    int textWidth = font.width(textComponent);
                    if (textWidth <= maxTextWidth) continue;
                    maxTextWidth = textWidth;
                }
                int startX = this.x + 12;
                int startY = this.y - 12;
                int heightOffset = 8;
                if (this.texts.size() > 1) {
                    heightOffset += 2 + (this.texts.size() - 1) * 10;
                }
                if (startX + maxTextWidth > width) {
                    startX -= 28 + maxTextWidth;
                }
                if (startY + heightOffset + 6 > height) {
                    startY = height - heightOffset - 6;
                }
                int background = this.type.backgroundColor;
                int fadeMin = this.type.backgroundFadeMinColor;
                int fadeMax = this.type.backgroundFadeMaxColor;
                graphics.fillGradient(startX - 3, startY - 4, startX + maxTextWidth + 3, startY - 3, background, background);
                graphics.fillGradient(startX - 3, startY + heightOffset + 3, startX + maxTextWidth + 3, startY + heightOffset + 4, background, background);
                graphics.fillGradient(startX - 3, startY - 3, startX + maxTextWidth + 3, startY + heightOffset + 3, background, background);
                graphics.fillGradient(startX - 4, startY - 3, startX - 3, startY + heightOffset + 3, background, background);
                graphics.fillGradient(startX + maxTextWidth + 3, startY - 3, startX + maxTextWidth + 4, startY + heightOffset + 3, background, background);
                graphics.fillGradient(startX - 3, startY - 3 + 1, startX - 3 + 1, startY + heightOffset + 3 - 1, fadeMin, fadeMax);
                graphics.fillGradient(startX + maxTextWidth + 2, startY - 3 + 1, startX + maxTextWidth + 3, startY + heightOffset + 3 - 1, fadeMin, fadeMax);
                graphics.fillGradient(startX - 3, startY - 3, startX + maxTextWidth + 3, startY - 3 + 1, fadeMin, fadeMin);
                graphics.fillGradient(startX - 3, startY + heightOffset + 2, startX + maxTextWidth + 3, startY + heightOffset + 3, fadeMax, fadeMax);
                graphics.nextStratum();
                for (int i = 0; i < this.texts.size(); ++i) {
                    FormattedCharSequence textComponent = this.texts.get(i);
                    graphics.drawString(font, textComponent, startX, startY, this.textColor, false);
                    if (i == 0) {
                        startY += 2;
                    }
                    startY += 10;
                }
            }
        }
    }
}

