/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.screen;

import dev.toma.configuration.Configuration;
import dev.toma.configuration.ConfigurationOptions;
import dev.toma.configuration.client.screen.AbstractConfigScreen;
import dev.toma.configuration.client.theme.ConfigTheme;
import dev.toma.configuration.client.theme.adapter.DisplayAdapter;
import dev.toma.configuration.client.widget.ConfigEntryWidget;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.value.ConfigValue;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

public class ConfigScreen
extends AbstractConfigScreen {
    private final Map<String, ConfigValue<?>> configValueMap;
    private final Map<String, ConfigValue<?>> valueMap = new LinkedHashMap();

    public ConfigScreen(ConfigHolder<?> configHolder, Component screenTitle, Map<String, ConfigValue<?>> valueMap, Screen previous) {
        super(screenTitle, previous, configHolder);
        this.configValueMap = valueMap;
    }

    protected void init() {
        int viewportMin = 35;
        int viewportHeight = this.height - 35 - 30;
        this.valueMap.clear();
        ConfigurationOptions options = Configuration.options.getConfigInstance();
        for (Map.Entry<String, ConfigValue<?>> entry : this.configValueMap.entrySet()) {
            ConfigValue<?> value = entry.getValue();
            if (!value.getFieldVisibility().isVisible(options)) continue;
            this.valueMap.put(entry.getKey(), value);
        }
        int spacing = 22;
        this.pageSize = (viewportHeight - 20) / spacing;
        this.correctScrollingIndex(this.valueMap.size());
        ArrayList values = new ArrayList(this.valueMap.values());
        int errorOffset = viewportHeight - 20 - (this.pageSize * spacing - 5);
        int offset = 0;
        for (int i = this.index; i < this.index + this.pageSize; ++i) {
            int j = i - this.index;
            if (i >= values.size()) break;
            int correct = errorOffset / (this.pageSize - j);
            errorOffset -= correct;
            ConfigValue value = (ConfigValue)values.get(i);
            ConfigEntryWidget widget = (ConfigEntryWidget)this.addRenderableWidget((GuiEventListener)new ConfigEntryWidget(30, 45 + j * spacing + (offset += correct), this.width - 60, 20, value, this.getConfigId(), this.theme));
            widget.setDescriptionRenderer(this);
            TypeAdapter.AdapterContext context = value.getSerializationContext();
            Field field = context.getOwner();
            DisplayAdapter adapter = this.theme.getAdapter(field.getType());
            if (adapter == null) {
                Configuration.LOGGER.error(MARKER, "Missing display adapter for {} type, will not be displayed in GUI", (Object)field.getType().getSimpleName());
                continue;
            }
            try {
                adapter.placeWidgets(this.holder, value, field, this.theme, widget);
                continue;
            }
            catch (ClassCastException e) {
                Configuration.LOGGER.error(MARKER, (Message)new FormattedMessage("Unable to create config field for {}", (Object)field.getType().getSimpleName()), (Throwable)e);
            }
        }
        this.addSettingsButton();
        this.addFooter();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (ConfigScreen.canRenderBackground(this.minecraft)) {
            ConfigTheme.Header themeHeader = this.theme.getHeader();
            ConfigTheme.Footer footer = this.theme.getFooter();
            Component headerLabel = themeHeader.customText() != null ? themeHeader.customText() : this.title;
            int titleWidth = this.font.width((FormattedText)headerLabel);
            graphics.fill(0, 0, this.width, 35, themeHeader.backgroundColor());
            int n = (this.width - titleWidth) / 2;
            Objects.requireNonNull(this.font);
            graphics.drawString(this.font, headerLabel, n, (35 - 9) / 2, themeHeader.foregroundColor(), true);
            graphics.fill(0, this.height - 30, this.width, this.height, footer.backgroundColor());
            Integer fillColor = this.theme.getBackgroundFillColor();
            if (fillColor != null) {
                graphics.fill(0, 35, this.width, this.height - 30, fillColor.intValue());
            }
        }
        this.renderables.forEach(renderable -> renderable.render(graphics, mouseX, mouseY, partialTicks));
        ConfigTheme.Scrollbar scrollbar = this.theme.getScrollbar();
        ConfigScreen.renderScrollbar(graphics, this.width - scrollbar.width(), 35, scrollbar.width(), this.height - 30 - 35, this.index, this.valueMap.size(), this.pageSize, scrollbar.backgroundColor());
        this.renderPost(graphics, partialTicks);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        int scale = (int)(-amountY);
        int next = this.index + scale;
        if (next >= 0 && next + this.pageSize <= this.valueMap.size()) {
            this.index = next;
            this.init(this.width, this.height);
            return true;
        }
        return false;
    }
}

