/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.widget;

import dev.toma.configuration.client.WidgetAdder;
import dev.toma.configuration.client.screen.AbstractConfigScreen;
import dev.toma.configuration.client.screen.WidgetPlacerHelper;
import dev.toma.configuration.client.theme.ConfigTheme;
import dev.toma.configuration.client.widget.ContainerWidget;
import dev.toma.configuration.config.validate.ValidationResult;
import dev.toma.configuration.config.value.ConfigValue;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ActiveTextCollector;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

public class ConfigEntryWidget
extends ContainerWidget
implements WidgetAdder {
    public static final Component OPEN = Component.translatable((String)"text.configuration.value.open");
    public static final Component APPLY = Component.translatable((String)"text.configuration.value.apply");
    public static final Component REVERT_DEFAULTS = Component.translatable((String)"text.configuration.value.revert.default");
    public static final Component REVERT_DEFAULTS_DIALOG_TEXT = Component.translatable((String)"text.configuration.value.revert.default.dialog");
    public static final Component REVERT_CHANGES = Component.translatable((String)"text.configuration.value.revert.changes");
    public static final Component REVERT_CHANGES_DIALOG_TEXT = Component.translatable((String)"text.configuration.value.revert.changes.dialog");
    private final String configId;
    private final ConfigValue<?> configValue;
    private final List<Component> description;
    private final ConfigTheme theme;
    private ValidationResult result = ValidationResult.success();
    private IValidationRenderer renderer;
    private boolean lastHoverState;
    private long hoverTimeStart;

    public ConfigEntryWidget(int x, int y, int w, int h, ConfigValue<?> value, String configId, ConfigTheme theme) {
        this(x, y, w, h, value.getValueData().getTitle(), value, configId, theme);
    }

    public ConfigEntryWidget(int x, int y, int w, int h, Component label, ConfigValue<?> value, String configId, ConfigTheme theme) {
        super(x, y, w, h, label);
        this.configValue = value;
        this.configId = configId;
        this.description = value.getDescription();
        this.theme = theme;
    }

    public void setDescriptionRenderer(IValidationRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public Component getComponentName() {
        return this.getMessage();
    }

    public void updateWidgetNarration(NarrationElementOutput p_169152_) {
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        ConfigTheme.ConfigEntry configEntry = this.theme.getConfigEntry();
        if (this.isHovered) {
            if (!this.lastHoverState) {
                this.hoverTimeStart = System.currentTimeMillis();
            }
            if (configEntry.hoveredColorBackground() != null) {
                graphics.fill(this.getX() - 30, this.getY() - 2, this.getRight() + 30, this.getBottom() + 2, configEntry.hoveredColorBackground().intValue());
            }
        }
        ValidationResult validationResult = this.getValidationResult();
        boolean isError = this.hasGuiError();
        MutableComponent label = Component.literal((String)this.getMessage().getString()).withStyle(this.getMessage().getStyle());
        UnaryOperator<Style> modifiedStyle = configEntry.modifiedValueStyle();
        if (this.configValue.isChanged() && modifiedStyle != null) {
            label.withStyle((Style)modifiedStyle.apply(label.getStyle()));
        }
        int entryLeft = WidgetPlacerHelper.getLeft(this.getX(), this.width);
        boolean backgroundRenderMode = AbstractConfigScreen.canRenderBackground(minecraft);
        if (backgroundRenderMode || this.isHovered) {
            this.renderScrollingString((Component)label, entryLeft - 5, backgroundRenderMode ? configEntry.color() : -1, graphics.textRendererForWidget((AbstractWidget)this, GuiGraphics.HoveredTextEffects.NONE));
        }
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        ValidationResult.Type type = validationResult.type();
        boolean validationRendering = false;
        if (type.isWarningOrError()) {
            validationRendering = true;
            this.renderer.drawIcon(graphics, this, type);
        }
        if ((isError || this.isHovered) && this.renderer != null) {
            long totalHoverTime = System.currentTimeMillis() - this.hoverTimeStart;
            if (isError || totalHoverTime >= 750L) {
                boolean hasDescription;
                List<Component> messages = validationRendering ? validationResult.description() : this.description;
                List<FormattedCharSequence> lines = messages.stream().flatMap(text -> font.split((FormattedText)text, this.width / 2).stream()).toList();
                boolean bl = hasDescription = lines.size() > 1 || lines.size() == 1 && !((FormattedCharSequence)lines.getFirst()).equals((Object)CommonComponents.EMPTY);
                if (hasDescription) {
                    this.renderer.drawDescription(graphics, this, lines, type, type.textColor);
                }
            }
        }
        this.lastHoverState = this.isHovered;
    }

    public void renderScrollingString(Component text, int right, int color, ActiveTextCollector textCollector) {
        int left = this.getX();
        int top = this.getY();
        int bottom = this.getBottom();
        MutableComponent coloredText = text.copy().withStyle(style -> style.withColor(color));
        textCollector.acceptScrolling((Component)coloredText, left, left, right, top, bottom, textCollector.defaultParameters());
    }

    @Override
    public void setValidationResult(ValidationResult result) {
        this.result = result;
    }

    @Override
    public <W extends AbstractWidget> W addConfigWidget(boolean editableCheck, WidgetAdder.ToWidgetFunction<W> function) {
        W widget = function.asWidget(this.getX(), this.getY(), this.width, this.height, this.configId);
        if (editableCheck) {
            ((AbstractWidget)widget).active = this.configValue.isEditable();
        }
        return this.addRenderableWidget(widget);
    }

    private ValidationResult getValidationResult() {
        ValidationResult valueResult = this.configValue.getValidationResult() != null ? this.configValue.getValidationResult() : ValidationResult.success();
        return valueResult.type().isMoreSevereThan(this.result.type()) ? valueResult : this.result;
    }

    private boolean hasGuiError() {
        ValidationResult result = this.getValidationResult();
        return !result.type().isValid();
    }

    public static interface IValidationRenderer {
        public void drawIcon(GuiGraphics var1, AbstractWidget var2, ValidationResult.Type var3);

        public void drawDescription(GuiGraphics var1, AbstractWidget var2, List<FormattedCharSequence> var3, ValidationResult.Type var4, int var5);
    }
}

