/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.widget;

import dev.toma.configuration.client.theme.ConfigTheme;
import dev.toma.configuration.client.widget.AbstractThemeWidget;
import dev.toma.configuration.client.widget.ConfigurationRenderUtils;
import dev.toma.configuration.client.widget.render.IRenderer;
import dev.toma.configuration.config.value.NumericValue;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;

public class SliderWidget<N extends Number>
extends AbstractThemeWidget {
    public static final WidgetSprites SLIDER = new WidgetSprites(Identifier.withDefaultNamespace((String)"widget/slider"), Identifier.withDefaultNamespace((String)"widget/slider_highlighted"));
    public static final WidgetSprites HANDLE = new WidgetSprites(Identifier.withDefaultNamespace((String)"widget/slider_handle"), Identifier.withDefaultNamespace((String)"widget/slider_handle_highlighted"));
    protected final Font font;
    protected final NumericValue<N> numericValue;
    protected IRenderer handleRenderer;
    protected double value;
    protected N num;
    private DecimalFormat decimalFormat;

    public SliderWidget(int x, int y, int width, int height, ConfigTheme theme, NumericValue<N> numericValue, Font font) {
        super(x, y, width, height, theme);
        this.numericValue = numericValue;
        this.value = numericValue.getSliderValue();
        this.font = font;
        this.updateDisplayText();
    }

    public void setFormatter(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
        this.updateDisplayText();
    }

    public void setHandleRenderer(IRenderer handleRenderer) {
        this.handleRenderer = handleRenderer;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float deltaTick) {
        this.renderBackground(guiGraphics);
        this.applyRenderer(this.handleRenderer, guiGraphics, this.getX() + (int)(this.value * ((double)this.width - 8.0)), this.getY(), 8, this.getHeight());
        int textColor = this.theme.getWidgetTextColor(this.active, this.isHovered);
        ConfigurationRenderUtils.renderCenteredScrollingString(this, this.getMessage(), textColor, 2, guiGraphics.textRendererForWidget((AbstractWidget)this, GuiGraphics.HoveredTextEffects.NONE));
    }

    public void onClick(MouseButtonEvent event, boolean doubleClick) {
        this.setValueFromMouse(event.x());
    }

    private void setValueFromMouse(double x) {
        this.setValue((x - ((double)this.getX() + 4.0)) / ((double)this.width - 8.0));
    }

    public void setValue(double value) {
        double oldValue = this.value;
        this.value = Mth.clamp((double)value, (double)0.0, (double)1.0);
        if (oldValue != this.value) {
            N updatedValue = this.numericValue.getValueFromSlider(this.value);
            this.numericValue.setValue(updatedValue);
            this.setChanged();
        }
        this.updateDisplayText();
    }

    protected void updateDisplayText() {
        this.num = (Number)this.numericValue.get();
        this.setMessage((Component)Component.literal((String)(this.decimalFormat != null ? this.decimalFormat.format(this.num) : String.valueOf(this.num))));
    }

    protected void onDrag(MouseButtonEvent event, double dragX, double dragY) {
        this.setValueFromMouse(event.x());
        super.onDrag(event, dragX, dragY);
    }

    public void playDownSound(SoundManager $$0) {
    }

    public void onRelease(MouseButtonEvent event) {
        super.playDownSound(Minecraft.getInstance().getSoundManager());
    }

    @Override
    protected void updateWidgetNarration(NarrationElementOutput output) {
    }
}

