/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.io;

import dev.toma.configuration.Configuration;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.exception.ConfigReadException;
import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.format.IConfigFormatHandler;
import dev.toma.configuration.config.io.FileWatchManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

public final class ConfigurationFileManager {
    public static final Marker MARKER = MarkerManager.getMarker((String)"ConfigurationFileManager");
    public static final FileWatchManager FILE_WATCH_MANAGER = new FileWatchManager();
    private static ConfigEnvironment environment = ConfigEnvironment.LOADING;

    public static void processConfig(ConfigHolder<?> holder) {
        Configuration.LOGGER.debug(MARKER, "Starting processing of config {}", (Object)holder.getConfigId());
        ConfigurationFileManager.processSafely(holder, () -> {
            File file = ConfigurationFileManager.getConfigFile(holder);
            if (file.exists()) {
                try {
                    ConfigurationFileManager.readConfig(holder);
                }
                catch (IOException e) {
                    Configuration.LOGGER.error(MARKER, "Config read failed for config ID {}, will create default config file", (Object)holder.getConfigId());
                }
            }
            try {
                ConfigurationFileManager.writeConfig(holder);
            }
            catch (IOException e) {
                Configuration.LOGGER.fatal(MARKER, "Couldn't write config {}, aborting mod startup", (Object)holder.getConfigId());
                throw new RuntimeException("Config write failed", e);
            }
        });
        Configuration.LOGGER.debug(MARKER, "Processing of config {} has finished", (Object)holder.getConfigId());
    }

    public static void reloadClientValues(ConfigHolder<?> configHolder) {
        ConfigurationFileManager.processSafely(configHolder, () -> {
            try {
                ConfigurationFileManager.readConfig(configHolder);
            }
            catch (IOException e) {
                Configuration.LOGGER.error(MARKER, "Failed to read config file {}", (Object)configHolder.getConfigId());
            }
        });
    }

    public static void saveClientValues(ConfigHolder<?> configHolder) {
        ConfigurationFileManager.processSafely(configHolder, () -> {
            try {
                configHolder.save();
                ConfigurationFileManager.writeConfig(configHolder);
            }
            catch (IOException e) {
                Configuration.LOGGER.error(MARKER, "Failed to write config file {}", (Object)configHolder.getConfigId());
            }
        });
    }

    public static void runGameInitEvents() {
        for (ConfigHolder<?> holder : ConfigHolder.configs()) {
            ConfigurationFileManager.processSafely(holder, holder::runGameInitEvents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processSafely(ConfigHolder<?> holder, Runnable action) {
        try {
            Object object = holder.getLock();
            synchronized (object) {
                action.run();
            }
        }
        catch (Exception e) {
            Configuration.LOGGER.fatal(MARKER, (Message)new FormattedMessage("Error loading config {} due to critical error. Report this issue to this config's owner!", (Object)holder.getConfigId()), (Throwable)e);
            throw new ReportedException(CrashReport.forThrowable((Throwable)e, (String)("Config " + holder.getConfigId() + " failed. Report issue to config owner")));
        }
    }

    private static void readConfig(ConfigHolder<?> holder) throws IOException {
        Configuration.LOGGER.debug(MARKER, "Reading config {}", (Object)holder.getConfigId());
        IConfigFormat format = holder.getFormat().createFormat();
        File file = ConfigurationFileManager.getConfigFile(holder);
        if (!file.exists()) {
            return;
        }
        try {
            format.readFile(file);
            holder.values().forEach(value -> value.deserializeValue(format));
            holder.save();
        }
        catch (ConfigReadException e) {
            Configuration.LOGGER.error(MARKER, "Config read failed, using default values", (Throwable)e);
        }
    }

    public static void writeConfig(ConfigHolder<?> holder) throws IOException {
        Configuration.LOGGER.debug(MARKER, "Writing config {}", (Object)holder.getConfigId());
        File file = ConfigurationFileManager.getConfigFile(holder);
        File dir = file.getParentFile();
        if (dir.mkdirs()) {
            Configuration.LOGGER.debug(MARKER, "Created file directories at {}", (Object)dir.getAbsolutePath());
        }
        if (!file.exists() && !file.createNewFile()) {
            throw new RuntimeException("Config file create failed");
        }
        IConfigFormatHandler handler = holder.getFormat();
        IConfigFormat format = handler.createFormat();
        holder.values().forEach(value -> value.serializeValue(format));
        format.writeFile(file);
    }

    public static File getConfigFile(ConfigHolder<?> holder) {
        IConfigFormatHandler handler = holder.getFormat();
        String Filename = holder.getFilename();
        String groupname = holder.getGroup();
        String filename = holder.getUnifiedFolder() ? groupname + "/" + Filename + "." + handler.fileExt() : Filename + "." + handler.fileExt();
        return Paths.get("config", filename).toFile();
    }

    public static void serverStarted() {
        ConfigurationFileManager.setEnvironment(ConfigEnvironment.PLAYING);
    }

    public static void serverStopping() {
        ConfigurationFileManager.setEnvironment(ConfigEnvironment.MENU);
    }

    public static ConfigEnvironment getEnvironment() {
        return environment;
    }

    public static void setEnvironment(ConfigEnvironment environment) {
        ConfigurationFileManager.environment = environment;
        Configuration.LOGGER.debug(MARKER, "Setting configuration environment to {}", (Object)environment);
    }

    public static enum ConfigEnvironment {
        LOADING,
        MENU,
        PLAYING;

    }
}

