/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.validate;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;

public record ValidationResult(Type type, List<Component> description) {
    public static final ValidationResult SUCCESS = new ValidationResult(Type.SUCCESS, Collections.emptyList());

    public static ValidationResult success() {
        return SUCCESS;
    }

    public static ValidationResult warning(List<Component> description) {
        return new ValidationResult(Type.WARNING, description);
    }

    public static ValidationResult warning(Component description) {
        return ValidationResult.warning(Collections.singletonList(description));
    }

    public static ValidationResult error(List<Component> description) {
        return new ValidationResult(Type.ERROR, description);
    }

    public static ValidationResult error(Component description) {
        return ValidationResult.error(Collections.singletonList(description));
    }

    public boolean isValid() {
        return this.type.isValid();
    }

    public boolean isWarningOrError() {
        return this.type.isWarningOrError();
    }

    public static enum Type {
        SUCCESS(-2039584, -268238055, 1344574437, 1344563685),
        WARNING(-22016, -262784768, 1358934528, 1352558848),
        ERROR(-43691, -265879546, 0x50FF0000, 0x50880000);

        public final int textColor;
        public final int backgroundColor;
        public final int backgroundFadeMinColor;
        public final int backgroundFadeMaxColor;
        public final Identifier iconPath;

        private Type(int textColor, int backgroundColor, int backgroundFadeMinColor, int backgroundFadeMaxColor) {
            this.textColor = textColor;
            this.backgroundColor = backgroundColor;
            this.backgroundFadeMinColor = backgroundFadeMinColor;
            this.backgroundFadeMaxColor = backgroundFadeMaxColor;
            this.iconPath = Identifier.fromNamespaceAndPath((String)"configuration", (String)("textures/icons/" + this.name().toLowerCase(Locale.ROOT) + ".png"));
        }

        public boolean isWarningOrError() {
            return this != SUCCESS;
        }

        public boolean isValid() {
            return this != ERROR;
        }

        public boolean isMoreSevereThan(Type other) {
            return this.ordinal() > other.ordinal();
        }

        public boolean isSameOrMoreSevereThan(Type other) {
            return this.ordinal() >= other.ordinal();
        }
    }
}

