/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.value;

import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.exception.ConfigValueMissingException;
import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.value.AbstractArrayValue;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.EnumValue;
import dev.toma.configuration.config.value.IConfigValueReadable;
import dev.toma.configuration.config.value.ValueData;
import java.lang.reflect.Array;
import net.minecraft.network.FriendlyByteBuf;

public class EnumArrayValue<E extends Enum<E>>
extends AbstractArrayValue<E> {
    public EnumArrayValue(ValueData<E[]> value) {
        super(value);
    }

    @Override
    public E createElementInstance() {
        Class<E> enumType = this.getElementType();
        Enum[] constants = (Enum[])enumType.getEnumConstants();
        if (constants.length == 0) {
            throw new IllegalArgumentException("Enum does not define any constants");
        }
        return (E)constants[0];
    }

    public Class<E> getElementType() {
        return this.valueData.getValueType().getComponentType();
    }

    @Override
    protected void serialize(IConfigFormat format) {
        format.addComments(EnumValue.getValidEnumEntriesAsString(this.getElementType()));
        format.writeEnumArray(this.getId(), (Enum[])this.get(IConfigValueReadable.Mode.SAVED));
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        Class<?> type = this.getValueType().getComponentType();
        this.setValue(format.readEnumArray(this.getId(), type));
    }

    public static final class Adapter<E extends Enum<E>>
    extends TypeAdapter<E[]> {
        @Override
        public ConfigValue<E[]> serialize(TypeAdapter.TypeAttributes<E[]> attributes, Object instance, TypeAdapter.TypeSerializer serializer) throws IllegalAccessException {
            return new EnumArrayValue(ValueData.of(attributes));
        }

        @Override
        public void encodeToBuffer(ConfigValue<E[]> value, FriendlyByteBuf buffer) {
            Enum[] values = (Enum[])value.get();
            buffer.writeInt(values.length);
            for (Enum e : values) {
                buffer.writeEnum(e);
            }
        }

        @Override
        public E[] decodeFromBuffer(ConfigValue<E[]> value, FriendlyByteBuf buffer) {
            int count = buffer.readInt();
            Class<?> type = value.getValueType().getComponentType();
            Enum[] enumArray = (Enum[])Array.newInstance(type, count);
            for (int i = 0; i < count; ++i) {
                enumArray[i] = buffer.readEnum(type);
            }
            return enumArray;
        }
    }
}

