/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.network.message;

import dev.toma.configuration.Configuration;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.value.ConfigValue;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;

public record S2C_SendConfigDataMessage(String config, Map<String, NetworkConfigValue<?>> values) implements CustomPacketPayload
{
    public static final Identifier IDENTIFIER = Identifier.fromNamespaceAndPath((String)"configuration", (String)"send_config_data");
    public static final CustomPacketPayload.Type<S2C_SendConfigDataMessage> TYPE = new CustomPacketPayload.Type(IDENTIFIER);
    public static final StreamCodec<FriendlyByteBuf, S2C_SendConfigDataMessage> CODEC = StreamCodec.of((o, s2CSendConfigDataMessage) -> s2CSendConfigDataMessage.encode((FriendlyByteBuf)o), S2C_SendConfigDataMessage::decode);

    public S2C_SendConfigDataMessage(String config) {
        this(config, null);
    }

    private static Map<String, ConfigValue<?>> loadValuesForSynchronization(String config) {
        ConfigHolder holder = ConfigHolder.getConfig(config).orElseThrow(() -> new IllegalArgumentException("Unknown config: " + config));
        return holder.getNetworkSerializedFields();
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    private void encode(FriendlyByteBuf buffer) {
        Map<String, ConfigValue<?>> synchronizedFields = S2C_SendConfigDataMessage.loadValuesForSynchronization(this.config);
        buffer.writeUtf(this.config);
        buffer.writeInt(synchronizedFields.size());
        for (Map.Entry<String, ConfigValue<?>> entry : synchronizedFields.entrySet()) {
            String field = entry.getKey();
            ConfigValue<?> value = entry.getValue();
            buffer.writeUtf(field);
            this.encodeToBuffer(value, buffer);
        }
    }

    private <T> void encodeToBuffer(ConfigValue<T> value, FriendlyByteBuf buffer) {
        TypeAdapter<T> adapter = value.getAdapter();
        adapter.encodeToBuffer(value, buffer);
    }

    private static S2C_SendConfigDataMessage decode(FriendlyByteBuf buffer) {
        Map<String, ConfigValue<?>> synchronizedFields;
        String config = buffer.readUtf();
        int valuesCount = buffer.readInt();
        if (valuesCount != (synchronizedFields = S2C_SendConfigDataMessage.loadValuesForSynchronization(config)).size()) {
            throw new IllegalArgumentException("Number of synchronization fields did not match for config " + config);
        }
        LinkedHashMap values = new LinkedHashMap();
        for (int i = 0; i < valuesCount; ++i) {
            String field = buffer.readUtf();
            ConfigValue<?> configValue = synchronizedFields.get(field);
            if (configValue == null) {
                Configuration.LOGGER.fatal("Received unknown config value {}", (Object)field);
                throw new RuntimeException("Unknown config field: " + field);
            }
            S2C_SendConfigDataMessage.saveValue(values, configValue, field, buffer);
        }
        return new S2C_SendConfigDataMessage(config, values);
    }

    private static <T> void saveValue(Map<String, NetworkConfigValue<?>> map, ConfigValue<T> value, String field, FriendlyByteBuf buffer) {
        TypeAdapter<T> adapter = value.getAdapter();
        T t = adapter.decodeFromBuffer(value, buffer);
        map.put(field, new NetworkConfigValue<T>(value, t));
    }

    public void receive() {
        for (Map.Entry<String, NetworkConfigValue<?>> entry : this.values.entrySet()) {
            NetworkConfigValue<?> value = entry.getValue();
            value.bind();
        }
    }

    private record NetworkConfigValue<T>(ConfigValue<T> configValue, T value) {
        void bind() {
            this.configValue.setFromNetwork(this.value);
        }
    }
}

