/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.client.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.joml.Vector2f;
import org.joml.Vector4i;
import tnt.tarkovcraft.core.client.IconWithLabel;
import tnt.tarkovcraft.core.client.screen.CharacterSubScreen;
import tnt.tarkovcraft.core.client.screen.renderable.IconWithLabelRenderable;
import tnt.tarkovcraft.core.client.screen.renderable.ShapeRenderable;
import tnt.tarkovcraft.core.util.HorizontalAlignment;
import tnt.tarkovcraft.medsystem.MedicalSystem;
import tnt.tarkovcraft.medsystem.api.event.client.RegisterHealthScreenLabelsEvent;
import tnt.tarkovcraft.medsystem.client.MedicalSystemClient;
import tnt.tarkovcraft.medsystem.client.screen.widget.BodyPartHealthWidget;
import tnt.tarkovcraft.medsystem.client.screen.widget.BodyPartWidget;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffectType;
import tnt.tarkovcraft.medsystem.common.effect.util.EffectVisibility;
import tnt.tarkovcraft.medsystem.common.health.BodyPartDisplay;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.HealthContainerDefinition;
import tnt.tarkovcraft.medsystem.common.health.Limb;
import tnt.tarkovcraft.medsystem.common.init.MedSystemDataAttachments;

public class HealthScreen
extends CharacterSubScreen {
    public static final Identifier HEALTH_ICON = MedicalSystem.createIdentifier("textures/icons/health.png");
    public static final float UNIT_SCALE = 10.0f;
    private HealthContainer healthContainer;

    public HealthScreen(Screen parent, UUID userId) {
        super(userId, MedicalSystemClient.HEALTH);
    }

    protected void init() {
        super.init();
        this.addRenderableOnly((Renderable)new ShapeRenderable(0, 25, this.width, this.height - 25, 0x44000000));
        this.healthContainer = (HealthContainer)this.minecraft.player.getData(MedSystemDataAttachments.HEALTH_CONTAINER);
        HealthContainerDefinition definition = this.healthContainer.getDefinition();
        ArrayList<IconWithLabel> list = new ArrayList<IconWithLabel>();
        list.add(new IconWithLabel(HEALTH_ICON, () -> Component.literal((String)(Mth.floor((float)(this.healthContainer.getHealth() * 10.0f)) + "/" + Mth.floor((float)(this.healthContainer.getMaxHealth() * 10.0f)))), -11141291, -11141291));
        NeoForge.EVENT_BUS.post((Event)new RegisterHealthScreenLabelsEvent(list));
        for (int i = 0; i < list.size(); ++i) {
            IconWithLabel icon = (IconWithLabel)list.get(i);
            Objects.requireNonNull(this.font);
            IconWithLabelRenderable renderable = (IconWithLabelRenderable)this.addRenderableOnly((Renderable)new IconWithLabelRenderable(this.font, 5, this.height - 5 - 9 - i * 11, this.width / 3, 10, HorizontalAlignment.LEFT, icon));
            renderable.setIconSize(10);
            renderable.setHorizontalTextOffset(5);
        }
        List<BodyPartDisplay> displays = definition.getDisplayConfiguration();
        Vector2f center = new Vector2f((float)this.width / 2.0f, (float)this.height / 2.0f);
        ArrayList<BodyPartHealthWidget> healthWidgets = new ArrayList<BodyPartHealthWidget>();
        float scale = (float)this.width / 256.0f;
        for (BodyPartDisplay display : displays) {
            String name = display.source();
            Limb part = this.healthContainer.getLimb(name);
            if (part == null) continue;
            Vector4i pos = display.getPositionForGui(scale, center);
            int x = pos.x;
            int y = pos.y;
            int width = pos.z;
            int height = pos.w;
            int xOffset = (int)((float)pos.x + (float)width / 2.0f - center.x);
            BodyPartWidget bodyPartWidget = (BodyPartWidget)this.addRenderableOnly((Renderable)new BodyPartWidget(x, y, width, height, part, this.font));
            bodyPartWidget.setScale(3);
            Stream<StatusEffect> stream = part.getStatusEffects().getEffectsStream();
            if (this.healthContainer.getRootLimb().getLimbCode().equals(part.getLimbCode())) {
                stream = Stream.concat(this.healthContainer.getGlobalStatusEffects().getEffectsStream(), stream);
            }
            List<StatusEffect> effects = stream.filter(ef -> StatusEffectType.isVisible(ef, EffectVisibility.UI)).toList();
            int healthWidth = 80;
            int healthHeight = effects.isEmpty() ? 20 : 33;
            int healthX = HealthScreen.getHealthLabelWidgetX(xOffset, x, healthWidth, width);
            int healthY = y + (height - healthHeight) / 2;
            BodyPartHealthWidget healthWidget = new BodyPartHealthWidget(healthX, healthY, healthWidth, healthHeight, this.font, part);
            healthWidget.setHealthUnitScale(10.0f);
            healthWidget.setEffects(effects);
            healthWidget.setTextHoverColor(-1);
            healthWidgets.add(healthWidget);
        }
        healthWidgets.forEach(x$0 -> {
            BodyPartHealthWidget cfr_ignored_0 = (BodyPartHealthWidget)this.addRenderableOnly((Renderable)x$0);
        });
    }

    static int getHealthLabelWidgetX(int xOffset, int posX, int labelWidth, int limbWidth) {
        if (xOffset == 0) {
            return posX + (limbWidth - labelWidth) / 2;
        }
        if (xOffset > 0) {
            return posX + limbWidth + 2;
        }
        return posX - labelWidth - 2;
    }
}

