/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.entity.living.ArmorHurtEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import tnt.tarkovcraft.core.api.MovementStaminaComponent;
import tnt.tarkovcraft.core.common.attribute.AttributeSystem;
import tnt.tarkovcraft.core.common.data.duration.Duration;
import tnt.tarkovcraft.core.common.energy.EnergySystem;
import tnt.tarkovcraft.core.common.skill.SkillSystem;
import tnt.tarkovcraft.medsystem.MedicalSystem;
import tnt.tarkovcraft.medsystem.api.event.WoundStatusEffectApplyEvent;
import tnt.tarkovcraft.medsystem.api.heal.SideEffectHolder;
import tnt.tarkovcraft.medsystem.common.armor.ArmorComponent;
import tnt.tarkovcraft.medsystem.common.armor.ArmorSystem;
import tnt.tarkovcraft.medsystem.common.config.MedSystemConfig;
import tnt.tarkovcraft.medsystem.common.effect.WoundStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.util.StatusEffectHelper;
import tnt.tarkovcraft.medsystem.common.health.DamageContext;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.HealthSystem;
import tnt.tarkovcraft.medsystem.common.health.HitResult;
import tnt.tarkovcraft.medsystem.common.health.Limb;
import tnt.tarkovcraft.medsystem.common.health.math.DamageDistributor;
import tnt.tarkovcraft.medsystem.common.health.math.HitCalculator;
import tnt.tarkovcraft.medsystem.common.init.MedSystemAttributes;
import tnt.tarkovcraft.medsystem.common.init.MedSystemDataAttachments;
import tnt.tarkovcraft.medsystem.common.init.MedSystemSkillEvents;
import tnt.tarkovcraft.medsystem.common.status.BloodData;
import tnt.tarkovcraft.medsystem.common.status.BloodSystem;

public final class DamageHandler {
    private static final Map<UUID, DamageContext> ACTIVE_DAMAGE_TRACKERS = new HashMap<UUID, DamageContext>();

    @SubscribeEvent
    private void onInvulnerabilityCheck(EntityInvulnerabilityCheckEvent event) {
        if (event.isInvulnerable()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (!HealthSystem.hasCustomHealth((Entity)livingEntity)) {
            return;
        }
        HealthContainer container = (HealthContainer)entity.getData(MedSystemDataAttachments.HEALTH_CONTAINER);
        DamageSource source = event.getSource();
        if (BloodSystem.isEntityUnconscious(livingEntity) && source.is(DamageTypes.IN_WALL)) {
            event.setInvulnerable(true);
            return;
        }
        HitCalculator hitCalculator = HealthSystem.getHitCalculator(livingEntity, source, container);
        List<HitResult> hits = hitCalculator.calculateHits(livingEntity, source, container);
        if (hits == null || hits.isEmpty()) {
            event.setInvulnerable(true);
        } else {
            ArmorSystem armorSystem = MedicalSystem.getConfig().armorSystem;
            ArmorComponent component = armorSystem.getComponent();
            if (!source.is(DamageTypeTags.BYPASSES_ARMOR) && component.shouldDeflectIncomingHit(source, livingEntity, hits)) {
                event.setInvulnerable(true);
            } else {
                DamageContext context = new DamageContext(livingEntity, source);
                context.setHits(hits);
                context.setHitCalculator(hitCalculator);
                context.setSideEffects(SideEffectHolder.fromDamage(source));
                ACTIVE_DAMAGE_TRACKERS.put(livingEntity.getUUID(), context);
            }
        }
    }

    @SubscribeEvent
    private void onLivingDamage(LivingIncomingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        if (!HealthSystem.hasCustomHealth((Entity)entity) || source.is(DamageTypeTags.BYPASSES_ARMOR)) {
            return;
        }
        if (entity.level().isClientSide()) {
            return;
        }
        ArmorSystem armorSystem = MedicalSystem.getConfig().armorSystem;
        ArmorComponent component = armorSystem.getComponent();
        DamageHandler.getDamageContext(entity).ifPresent(context -> {
            component.applyDamageReduction(event, (DamageContext)context);
            float armorReduction = event.getContainer().getReduction(DamageContainer.Reduction.ARMOR);
            if (armorReduction > 0.0f) {
                SkillSystem.triggerAndSynchronize(MedSystemSkillEvents.ARMOR_USE, (Entity)entity, (float)armorReduction);
            }
        });
    }

    @SubscribeEvent
    private void onLivingApplyDamage(LivingDamageEvent.Post event) {
        int duration;
        WoundStatusEffectApplyEvent applyEvent;
        LivingEntity entity = event.getEntity();
        if (!HealthSystem.hasCustomHealth((Entity)entity)) {
            return;
        }
        HealthContainer container = (HealthContainer)entity.getData(MedSystemDataAttachments.HEALTH_CONTAINER);
        DamageSource source = event.getSource();
        DamageContext context = ACTIVE_DAMAGE_TRACKERS.get(entity.getUUID());
        DamageDistributor damageDistributor = context.getDamageDistributor(container);
        Map<Limb, Float> distributedDamage = damageDistributor.distribute(context, container, event.getNewDamage());
        ArrayList lostLimbs = new ArrayList();
        SideEffectHolder sideEffects = context.getSideEffects();
        container.hurt(context, distributedDamage, sideEffects, lostLimbs::add);
        float totalDamage = distributedDamage.values().stream().reduce(Float.valueOf(0.0f), Float::sum).floatValue();
        if (!source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            SkillSystem.triggerAndSynchronize(MedSystemSkillEvents.DAMAGE_TAKEN, (Entity)entity, (float)totalDamage);
        }
        if ((applyEvent = (WoundStatusEffectApplyEvent)NeoForge.EVENT_BUS.post((Event)new WoundStatusEffectApplyEvent(entity, context, totalDamage, duration = Mth.floor((float)(totalDamage / 4.0f))))).shouldApplyEffect()) {
            StatusEffectHelper.addEffect(container.getGlobalStatusEffects(), entity, null, 1, new WoundStatusEffect(applyEvent.getDurationSeconds() * 20));
        }
        DamageHandler.clearDamageContext(entity);
        container.updateHealth(entity);
        HealthSystem.synchronizeEntity(entity);
        if (container.shouldDie()) {
            entity.setHealth(0.0f);
            return;
        }
        if (BloodSystem.hasBloodDataIntegration(entity) && !entity.level().isClientSide()) {
            float unconsciousChance;
            RandomSource random = entity.getRandom();
            BloodData bloodData = BloodSystem.getBloodData(entity);
            MedSystemConfig config = MedicalSystem.getConfig();
            int limbLostCount = lostLimbs.size();
            if (!bloodData.isUnconscious() && config.allowUnconsciousOnLimbLost && limbLostCount > 0 && (unconsciousChance = (float)limbLostCount * AttributeSystem.getFloatValue((Entity)entity, MedSystemAttributes.UNCONSCIOUS_ON_LIMB_LOSS_CHANCE, (float)0.2f)) > 0.0f && random.nextFloat() < unconsciousChance) {
                int unconsciousDuration = limbLostCount * Duration.seconds((int)10).tickValue();
                bloodData.setOrExtendedUnconsciousTime(unconsciousDuration, BloodData.UnconsciousInfo.PAIN);
            }
            bloodData.sync(entity);
        }
        MovementStaminaComponent component = (MovementStaminaComponent)EnergySystem.MOVEMENT_STAMINA.getComponent();
        if (entity.isSprinting() && !component.canSprint(entity)) {
            entity.setSprinting(false);
        }
    }

    @SubscribeEvent
    private void onArmorHit(ArmorHurtEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (!HealthSystem.hasCustomHealth((Entity)entity)) {
            return;
        }
        MedSystemConfig config = MedicalSystem.getConfig();
        ArmorSystem system = config.armorSystem;
        ArmorComponent component = system.getComponent();
        DamageHandler.getDamageContext(entity).ifPresent(context -> component.applyItemDamage(event, (DamageContext)context));
    }

    private static Optional<DamageContext> getDamageContext(LivingEntity entity) {
        return Optional.ofNullable(ACTIVE_DAMAGE_TRACKERS.get(entity.getUUID()));
    }

    private static void clearDamageContext(LivingEntity entity) {
        if (entity != null) {
            ACTIVE_DAMAGE_TRACKERS.remove(entity.getUUID());
        }
    }
}

