/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.armor;

import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import tnt.tarkovcraft.medsystem.common.armor.ArmorMaterial;
import tnt.tarkovcraft.medsystem.common.armor.ModularArmorComponent;
import tnt.tarkovcraft.medsystem.common.armor.ProjectileAttributes;
import tnt.tarkovcraft.medsystem.common.effect.ConcussionStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.util.StatusEffectHelper;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.HealthSystem;
import tnt.tarkovcraft.medsystem.common.health.HitResult;
import tnt.tarkovcraft.medsystem.common.health.Limb;
import tnt.tarkovcraft.medsystem.common.health.LimbType;
import tnt.tarkovcraft.medsystem.common.init.MedSystemDataAttachments;
import tnt.tarkovcraft.medsystem.common.init.MedSystemItemComponents;
import tnt.tarkovcraft.medsystem.common.status.BloodData;
import tnt.tarkovcraft.medsystem.common.status.BloodSystem;

public class SimulatedArmorComponent
extends ModularArmorComponent {
    public static final SimulatedArmorComponent INSTANCE = new SimulatedArmorComponent();
    public static final float DEFLECT_SCALE = 50.0f;
    public static final float MAX_DEFLECT_CHANCE = 0.75f;
    public static final float UNCONSCIOUS_ENERGY_THRESHOLD = 40.0f;
    public static final float CONCUSSION_ENERGY_THRESHOLD = 10.0f;

    SimulatedArmorComponent() {
        super(1.0f);
    }

    @Override
    public boolean shouldDeflectIncomingHit(DamageSource source, LivingEntity entity, List<HitResult> hits) {
        HitResult first = hits.getFirst();
        Limb limb = first.limb();
        LimbType type = limb.getType();
        if (type != LimbType.HEAD) {
            return false;
        }
        Entity projectile = source.getDirectEntity();
        if (projectile != null && !source.isDirect() && projectile.hasData(MedSystemDataAttachments.PROJECTILE_ATTRIBUTES)) {
            EquipmentSlot slot = EquipmentSlot.HEAD;
            ItemStack helmetItem = entity.getItemBySlot(slot);
            if (helmetItem.isEmpty()) {
                return false;
            }
            ArmorMaterial material = (ArmorMaterial)helmetItem.get(MedSystemItemComponents.ARMOR_MATERIAL);
            if (material == null) {
                return false;
            }
            ProjectileAttributes projectileAttributes = (ProjectileAttributes)projectile.getData(MedSystemDataAttachments.PROJECTILE_ATTRIBUTES);
            float baseDeflectionChance = material.deflectionChance();
            float rawEnergy = (float)projectile.getDeltaMovement().length() * projectileAttributes.massFactor();
            float deflectModifier = 1.0f / (1.0f + rawEnergy / 50.0f);
            float deflectProbability = Mth.clamp((float)(baseDeflectionChance * deflectModifier), (float)0.0f, (float)0.75f);
            RandomSource random = entity.getRandom();
            if (random.nextFloat() < deflectProbability) {
                if (rawEnergy >= 40.0f && BloodSystem.hasBloodDataIntegration(entity)) {
                    BloodData bloodData = BloodSystem.getBloodData(entity);
                    bloodData.setOrExtendedUnconsciousTime(Mth.floor((float)rawEnergy) * 5, BloodData.UnconsciousInfo.PAIN);
                    bloodData.sync(entity);
                } else if (rawEnergy >= 10.0f && HealthSystem.hasCustomHealth((Entity)entity)) {
                    HealthContainer container = HealthSystem.getHealthData(entity);
                    StatusEffectHelper.addEffect(container.getGlobalStatusEffects(), entity, null, new ConcussionStatusEffect(Mth.floor((float)rawEnergy) * 5));
                    HealthSystem.synchronizeEntity(entity);
                }
                return true;
            }
        }
        return false;
    }
}

