/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.effect;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import tnt.tarkovcraft.medsystem.common.effect.IntervalAppliedStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffectType;
import tnt.tarkovcraft.medsystem.common.effect.util.StatusEffectSubmitter;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.Limb;
import tnt.tarkovcraft.medsystem.common.init.MedSystemStatusEffects;
import tnt.tarkovcraft.medsystem.common.status.BloodData;
import tnt.tarkovcraft.medsystem.common.status.BloodStatus;
import tnt.tarkovcraft.medsystem.common.status.BloodSystem;

public class MildBloodLossStatusEffect
extends IntervalAppliedStatusEffect {
    public static final MapCodec<MildBloodLossStatusEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> MildBloodLossStatusEffect.common(instance).apply((Applicative)instance, MildBloodLossStatusEffect::new));

    public MildBloodLossStatusEffect() {
        super(-1);
    }

    private MildBloodLossStatusEffect(int duration) {
        super(duration);
    }

    @Override
    public int getUpdateInterval() {
        return 20;
    }

    @Override
    public void applyEffect(HealthContainer container, LivingEntity entity, @Nullable Limb limb) {
        if (!BloodSystem.hasBloodDataIntegration(entity)) {
            this.markForRemoval();
            return;
        }
        BloodData data = BloodSystem.getBloodData(entity);
        float percentage = data.getBloodVolumePercentage();
        if (BloodStatus.MODERATE_BLOOD_LOSS.isInRange(percentage) || !BloodStatus.MILD_BLOOD_LOSS.isInRange(percentage)) {
            this.markForRemoval();
        }
    }

    @Override
    public void onRemoved(StatusEffectSubmitter submitter, HealthContainer container, LivingEntity entity, @Nullable Limb limb) {
    }

    @Override
    public StatusEffect copy() {
        return new MildBloodLossStatusEffect(this.getDuration());
    }

    @Override
    public boolean hasVisibleDuration() {
        return false;
    }

    @Override
    public StatusEffectType<?> getType() {
        return (StatusEffectType)MedSystemStatusEffects.MILD_BLOODLOSS.value();
    }
}

