/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import tnt.tarkovcraft.medsystem.MedicalSystem;
import tnt.tarkovcraft.medsystem.common.effect.SimpleStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffectType;
import tnt.tarkovcraft.medsystem.common.init.MedSystemStatusEffects;

public class OverweightStatusEffect
extends SimpleStatusEffect {
    public static final MapCodec<OverweightStatusEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("limitExceeded", (Object)false).forGetter(t -> t.limitExceeded)).apply((Applicative)instance, OverweightStatusEffect::new));
    private static final Component HINT = Component.translatable((String)"status_effect.medsystem.overweight.info").withStyle(ChatFormatting.DARK_GRAY);
    private static final Component HINT_MAX = Component.translatable((String)"status_effect.medsystem.max_overweight.info").withStyle(ChatFormatting.DARK_GRAY);
    private static final Identifier MAX_OVERWEIGHT_ICON = MedicalSystem.createIdentifier("textures/icons/status_effect/max_overweight.png");
    private final boolean limitExceeded;

    public OverweightStatusEffect(boolean limitExceeded) {
        super(-1);
        this.limitExceeded = limitExceeded;
    }

    public static OverweightStatusEffect createTemplate(boolean limitExceeded) {
        return new OverweightStatusEffect(limitExceeded);
    }

    @Override
    public StatusEffect copy() {
        return new OverweightStatusEffect(this.limitExceeded);
    }

    @Override
    public StatusEffectType<?> getType() {
        return (StatusEffectType)MedSystemStatusEffects.OVERWEIGHT.value();
    }

    @Override
    public void addAdditionalInfo(Consumer<Component> tooltip) {
        tooltip.accept(this.limitExceeded ? HINT_MAX : HINT);
    }

    @Override
    public Identifier getCustomIcon() {
        return this.limitExceeded ? MAX_OVERWEIGHT_ICON : null;
    }
}

