/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.effect.group;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.LivingEntity;
import tnt.tarkovcraft.medsystem.api.heal.SideEffect;
import tnt.tarkovcraft.medsystem.common.effect.group.EffectGroupHolder;
import tnt.tarkovcraft.medsystem.common.effect.group.EffectGroupItem;
import tnt.tarkovcraft.medsystem.common.effect.group.EffectGroupItemType;
import tnt.tarkovcraft.medsystem.common.effect.util.EffectType;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.HealthSystem;
import tnt.tarkovcraft.medsystem.common.health.Limb;
import tnt.tarkovcraft.medsystem.common.init.MedSystemStatusEffectGroupItems;

public class DeadLimbRecoveryEffectGroupItem
implements EffectGroupItem {
    public static final MapCodec<DeadLimbRecoveryEffectGroupItem> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("health", (Object)Float.valueOf(1.0f)).forGetter(t -> Float.valueOf(t.health))).apply((Applicative)instance, DeadLimbRecoveryEffectGroupItem::new));
    private final float health;

    public DeadLimbRecoveryEffectGroupItem(float health) {
        this.health = health;
    }

    @Override
    public void init(EffectGroupHolder holder, HealthContainer container, LivingEntity entity, @Nullable Limb limb) {
        List<Limb> deadLimbs = container.getLimbsAsStream().filter(Limb::isDead).toList();
        for (Limb part : deadLimbs) {
            part.setHealth(this.health);
        }
        container.updateHealth(entity);
        HealthSystem.synchronizeEntity(entity);
    }

    @Override
    public void apply(EffectGroupHolder holder, HealthContainer container, LivingEntity entity, @Nullable Limb limb) {
    }

    @Override
    public void cleanup(EffectGroupHolder holder, HealthContainer container, LivingEntity entity, @Nullable Limb limb) {
    }

    @Override
    public void addInformation(EffectGroupHolder effectGroupHolder, Consumer<Component> consumer, boolean isItemTooltip) {
        if (!isItemTooltip) {
            return;
        }
        consumer.accept(SideEffect.createDescriptionComponent(EffectType.POSITIVE, (Component)Component.translatable((String)"label.medsystem.limb_recovery"), 1.0f, 0, effectGroupHolder.getDelay()));
    }

    @Override
    public EffectGroupItem copy() {
        return new DeadLimbRecoveryEffectGroupItem(this.health);
    }

    @Override
    public EffectGroupHolder tryToMergeWith(EffectGroupHolder effectGroupHolder, EffectGroupHolder effectGroupHolder1) {
        return null;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public EffectGroupItemType<?> getType() {
        return (EffectGroupItemType)MedSystemStatusEffectGroupItems.DEAD_LIMB_RECOVERY.value();
    }
}

