/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.health.reaction.event;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffectType;
import tnt.tarkovcraft.medsystem.common.effect.util.StatusEffectHelper;
import tnt.tarkovcraft.medsystem.common.effect.util.StatusEffectMap;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.Limb;
import tnt.tarkovcraft.medsystem.common.health.reaction.HealthEventSource;
import tnt.tarkovcraft.medsystem.common.health.reaction.event.HealthSourceEvent;
import tnt.tarkovcraft.medsystem.common.health.reaction.event.HealthSourceEventType;
import tnt.tarkovcraft.medsystem.common.init.MedSystemHealthReactionResponses;

public class StatusEffectSourceEvent
implements HealthSourceEvent {
    public static final MapCodec<StatusEffectSourceEvent> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)StatusEffectType.CODEC.fieldOf("effect").forGetter(t -> t.template)).apply((Applicative)instance, StatusEffectSourceEvent::new));
    private final StatusEffect template;

    public StatusEffectSourceEvent(StatusEffect template) {
        this.template = template;
    }

    @Override
    public void onReactionPassed(HealthEventSource source, HealthContainer container, LivingEntity entity, @Nullable DamageSource damageSource, Limb limb) {
        StatusEffectType<?> type = this.template.getType();
        StatusEffectMap map = type.isGlobalEffect() ? container.getGlobalStatusEffects() : limb.getStatusEffects();
        StatusEffectHelper.addEffect(map, entity, limb, this.template.copy());
    }

    @Override
    public HealthSourceEventType<?> getType() {
        return MedSystemHealthReactionResponses.EFFECT.get();
    }
}

