/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.health.reaction.function;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import tnt.tarkovcraft.core.common.data.number.NumberProvider;
import tnt.tarkovcraft.core.common.data.number.NumberProviderType;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.Limb;
import tnt.tarkovcraft.medsystem.common.health.reaction.function.ChanceFunction;
import tnt.tarkovcraft.medsystem.common.health.reaction.function.ChanceFunctionType;
import tnt.tarkovcraft.medsystem.common.init.MedSystemChanceFunctions;

public class FallDistanceScaleFunction
implements ChanceFunction {
    public static final MapCodec<FallDistanceScaleFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NumberProviderType.complexCodecNoDuration((Codec)Codec.FLOAT).optionalFieldOf("scale", (Object)Either.right((Object)Float.valueOf(1.0f))).forGetter(t -> Either.left((Object)t.scale))).apply((Applicative)instance, FallDistanceScaleFunction::new));
    private final NumberProvider scale;

    public FallDistanceScaleFunction(Either<NumberProvider, Float> scale) {
        this.scale = NumberProviderType.resolveNoDuration(scale);
    }

    @Override
    public float apply(float chance, HealthContainer container, LivingEntity entity, @Nullable DamageSource source, Limb limb) {
        double distance = entity.fallDistance;
        float scaleValue = this.scale.floatValue();
        return (float)(distance * (double)scaleValue) * chance;
    }

    @Override
    public ChanceFunctionType<?> getType() {
        return (ChanceFunctionType)MedSystemChanceFunctions.FALL_DISTANCE.value();
    }
}

