/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.init;

import java.util.Collections;
import net.minecraft.core.Holder;
import net.neoforged.neoforge.registries.DeferredRegister;
import tnt.tarkovcraft.medsystem.MedicalSystem;
import tnt.tarkovcraft.medsystem.common.effect.ConcussionStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.FractureStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.FreshWoundStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.GroupStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.HeavyBleedStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.InjuryRecoveryStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.LightBleedStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.MildBloodLossStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.ModerateBloodLossStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.NegativeEffectsGroup;
import tnt.tarkovcraft.medsystem.common.effect.NeutralEffectsGroup;
import tnt.tarkovcraft.medsystem.common.effect.OverweightStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.PainReliefEffect;
import tnt.tarkovcraft.medsystem.common.effect.PainStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.PositiveEffectsGroup;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffectType;
import tnt.tarkovcraft.medsystem.common.effect.UnconsciousStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.WoundStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.util.EffectType;
import tnt.tarkovcraft.medsystem.common.effect.util.EffectVisibility;
import tnt.tarkovcraft.medsystem.common.health.LimbType;
import tnt.tarkovcraft.medsystem.common.init.MedSystemRegistries;

public final class MedSystemStatusEffects {
    public static final DeferredRegister<StatusEffectType<?>> REGISTRY = DeferredRegister.create(MedSystemRegistries.Keys.STATUS_EFFECT, (String)"medsystem");
    public static final Holder<StatusEffectType<?>> PAIN_RELIEF = REGISTRY.register("pain_relief", key -> StatusEffectType.builder(key, PainReliefEffect::new).persist(PainReliefEffect.CODEC).type(EffectType.POSITIVE).setGlobal().combineEffects(StatusEffect::maxDuration).setPostEffects().build());
    public static final Holder<StatusEffectType<?>> PAIN = REGISTRY.register("pain", key -> StatusEffectType.builder(key, PainStatusEffect::new).persist(PainStatusEffect.CODEC).type(EffectType.NEGATIVE).setGlobal().combineEffects(StatusEffect::replace).setSpecial().setPostEffects().build());
    public static final Holder<StatusEffectType<?>> FRACTURE = REGISTRY.register("fracture", key -> StatusEffectType.builder(key, FractureStatusEffect::new).persist(FractureStatusEffect.CODEC).type(EffectType.NEGATIVE).combineEffects(StatusEffect::maxDuration).ignoresBodyParts(LimbType.HEAD, LimbType.TORSO, LimbType.STOMACH).healPriority(30).build());
    public static final Holder<StatusEffectType<?>> INJURY_RECOVERY = REGISTRY.register("injury_recovery", key -> StatusEffectType.builder(key, InjuryRecoveryStatusEffect::new).persist(InjuryRecoveryStatusEffect.CODEC).type(EffectType.NEGATIVE).visibility(EffectVisibility.UI).combineEffects(InjuryRecoveryStatusEffect::merge).healPriority(15).build());
    public static final Holder<StatusEffectType<?>> LIGHT_BLEED = REGISTRY.register("light_bleed", key -> StatusEffectType.builder(key, LightBleedStatusEffect::new).persist(LightBleedStatusEffect.CODEC).type(EffectType.NEGATIVE).healPriority(15).build());
    public static final Holder<StatusEffectType<?>> HEAVY_BLEED = REGISTRY.register("heavy_bleed", key -> StatusEffectType.builder(key, HeavyBleedStatusEffect::new).persist(HeavyBleedStatusEffect.CODEC).type(EffectType.NEGATIVE).healPriority(50).build());
    public static final Holder<StatusEffectType<?>> FRESH_WOUND = REGISTRY.register("fresh_wound", key -> StatusEffectType.builder(key, FreshWoundStatusEffect::new).persist(FreshWoundStatusEffect.CODEC).type(EffectType.NEGATIVE).healPriority(15).build());
    public static final Holder<StatusEffectType<?>> OVERWEIGHT = REGISTRY.register("overweight", key -> StatusEffectType.builder(key, duration -> new OverweightStatusEffect(false)).persist(OverweightStatusEffect.CODEC).type(EffectType.NEGATIVE).setGlobal().combineEffects(StatusEffect::keep).setSpecial().build());
    public static final Holder<StatusEffectType<?>> POSITIVE_EFFECTS_GROUP = REGISTRY.register("positive_effects_group", key -> StatusEffectType.builder(key, duration -> new PositiveEffectsGroup(Collections.emptyList())).persist(PositiveEffectsGroup.CODEC).type(EffectType.POSITIVE).setGlobal().combineEffects(GroupStatusEffect::merge).setSpecial().build());
    public static final Holder<StatusEffectType<?>> NEUTRAL_EFFECTS_GROUP = REGISTRY.register("neutral_effects_group", key -> StatusEffectType.builder(key, duration -> new NeutralEffectsGroup(Collections.emptyList())).persist(NeutralEffectsGroup.CODEC).type(EffectType.NEUTRAL).setGlobal().combineEffects(GroupStatusEffect::merge).setSpecial().build());
    public static final Holder<StatusEffectType<?>> NEGATIVE_EFFECTS_GROUP = REGISTRY.register("negative_effects_group", key -> StatusEffectType.builder(key, duration -> new NegativeEffectsGroup(Collections.emptyList())).persist(NegativeEffectsGroup.CODEC).type(EffectType.NEGATIVE).setGlobal().combineEffects(GroupStatusEffect::merge).setSpecial().build());
    public static final Holder<StatusEffectType<?>> WOUND = REGISTRY.register("wound", key -> StatusEffectType.builder(key, WoundStatusEffect::new).persist(WoundStatusEffect.CODEC).type(EffectType.NEGATIVE).combineEffects(WoundStatusEffect::mergeWithScaling).visibility(EffectVisibility.NEVER).healPriority(15).setGlobal().build());
    public static final Holder<StatusEffectType<?>> MILD_BLOODLOSS = REGISTRY.register("mild_bloodloss", key -> StatusEffectType.builder(key, duration -> new MildBloodLossStatusEffect()).persist(MildBloodLossStatusEffect.CODEC).type(EffectType.NEGATIVE).setGlobal().combineEffects(StatusEffect::keep).setSpecial().setPostEffectsWithBlocking(MedicalSystem.createIdentifier("pain_relief")).build());
    public static final Holder<StatusEffectType<?>> MODERATE_BLOODLOSS = REGISTRY.register("moderate_bloodloss", key -> StatusEffectType.builder(key, duration -> new ModerateBloodLossStatusEffect()).persist(ModerateBloodLossStatusEffect.CODEC).type(EffectType.NEGATIVE).setGlobal().combineEffects(StatusEffect::keep).setSpecial().setPostEffectsWithBlocking(MedicalSystem.createIdentifier("pain_relief")).build());
    public static final Holder<StatusEffectType<?>> UNCONSCIOUS = REGISTRY.register("unconscious", key -> StatusEffectType.builder(key, duration -> new UnconsciousStatusEffect()).persist(UnconsciousStatusEffect.CODEC).type(EffectType.NEGATIVE).visibility(EffectVisibility.NEVER).setGlobal().combineEffects(StatusEffect::replace).setSpecial().setPostEffects().build());
    public static final Holder<StatusEffectType<?>> CONCUSSION = REGISTRY.register("concussion", key -> StatusEffectType.builder(key, ConcussionStatusEffect::new).persist(ConcussionStatusEffect.CODEC).type(EffectType.NEGATIVE).setGlobal().setPostEffects().healPriority(15).build());
}

