/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.item;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import tnt.tarkovcraft.core.common.skill.SkillSystem;
import tnt.tarkovcraft.medsystem.common.health.HealthSystem;
import tnt.tarkovcraft.medsystem.common.init.MedSystemSkillEvents;
import tnt.tarkovcraft.medsystem.common.item.InteractableItem;
import tnt.tarkovcraft.medsystem.common.item.InteractionTarget;

public class SimpleHealingItem
extends InteractableItem {
    private ItemUseAnimation selfUseAnimation = ItemUseAnimation.BOW;
    private ItemUseAnimation otherUseAnimation = ItemUseAnimation.BOW;

    public SimpleHealingItem(Item.Properties properties) {
        super(properties);
    }

    public SimpleHealingItem withUseAnimations(ItemUseAnimation selfUseAnimation, ItemUseAnimation otherUseAnimation) {
        this.selfUseAnimation = Objects.requireNonNull(selfUseAnimation);
        this.otherUseAnimation = Objects.requireNonNull(otherUseAnimation);
        return this;
    }

    @Override
    protected boolean canUseItem(ItemStack itemStack, LivingEntity target, LivingEntity origin) {
        return super.canUseItem(itemStack, target, origin) && HealthSystem.hasCustomHealth((Entity)target);
    }

    @Override
    protected boolean tryInitiateExistingInteraction(ItemStack itemStack, InteractionTarget interaction, LivingEntity target, Player origin) {
        return false;
    }

    @Override
    protected InteractionResult initiateInteraction(ItemStack itemStack, InteractionTarget.Mutable interaction, LivingEntity target, Player origin) {
        return InteractionResult.SUCCESS;
    }

    @Override
    protected boolean updateInteraction(Level level, ItemStack itemStack, InteractionTarget interaction, LivingEntity target, LivingEntity origin, int remainingUseTicks) {
        return true;
    }

    @Override
    protected ItemStack finishInteraction(ItemStack itemStack, InteractionTarget interaction, LivingEntity target, LivingEntity origin) {
        Level level = origin.level();
        if (!level.isClientSide()) {
            SkillSystem.triggerAndSynchronize(MedSystemSkillEvents.HEALING_USED, (Entity)origin, (float)1.0f);
            if (itemStack.isDamageableItem()) {
                itemStack.hurtAndBreak(1, (ServerLevel)level, origin, item -> origin.onEquippedItemBroken(item, EquipmentSlot.MAINHAND));
            } else {
                itemStack.consume(1, origin);
            }
        }
        return itemStack;
    }

    @Override
    @Nullable
    protected Component getInteractionLabel(ItemStack itemStack, InteractionTarget interaction, LivingEntity target, LivingEntity origin, int time, boolean infinite) {
        return SimpleHealingItem.getCommonInteractionLabel(interaction, target, time, infinite);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 60;
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        InteractionTarget interaction = this.getActiveInteraction(stack);
        return interaction != null && !interaction.self() ? this.otherUseAnimation : this.selfUseAnimation;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        tooltipAdder.accept(SimpleHealingItem.getCommonDurabilityLabel(stack));
    }

    public static Component getCommonDurabilityLabel(ItemStack itemStack) {
        int max = Math.max(itemStack.getMaxDamage(), 1);
        int damage = max - itemStack.getDamageValue();
        MutableComponent durability = Component.literal((String)(damage + "/" + max)).withStyle(ChatFormatting.RED);
        return Component.translatable((String)"tooltip.medsystem.item.durability", (Object[])new Object[]{durability}).withStyle(ChatFormatting.GRAY);
    }

    public static Component getCommonInteractionLabel(InteractionTarget interaction, LivingEntity target, int time, boolean infinite) {
        if (interaction.self()) {
            return infinite ? Component.translatable((String)"label.medsystem.healing.self.infinite") : Component.translatable((String)"label.medsystem.healing.self", (Object[])new Object[]{SimpleHealingItem.formatUsageDuration(time)});
        }
        return infinite ? Component.translatable((String)"label.medsystem.healing.other.infinite", (Object[])new Object[]{target.getDisplayName()}) : Component.translatable((String)"label.medsystem.healing.other", (Object[])new Object[]{target.getDisplayName(), SimpleHealingItem.formatUsageDuration(time)});
    }
}

