/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.status;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import tnt.tarkovcraft.core.common.attribute.AttributeSystem;
import tnt.tarkovcraft.core.common.attribute.modifier.AttributeModifier;
import tnt.tarkovcraft.core.common.init.CoreAttributes;
import tnt.tarkovcraft.medsystem.MedicalSystem;
import tnt.tarkovcraft.medsystem.api.event.BloodEvent;
import tnt.tarkovcraft.medsystem.common.config.MedSystemConfig;
import tnt.tarkovcraft.medsystem.common.config.UnconsciousMode;
import tnt.tarkovcraft.medsystem.common.effect.MildBloodLossStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.ModerateBloodLossStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.UnconsciousStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.util.StatusEffectHelper;
import tnt.tarkovcraft.medsystem.common.effect.util.StatusEffectMap;
import tnt.tarkovcraft.medsystem.common.effect.util.StatusEffectSubmitter;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.HealthSystem;
import tnt.tarkovcraft.medsystem.common.init.MedSystemAttributes;
import tnt.tarkovcraft.medsystem.common.init.MedSystemDamageTypes;
import tnt.tarkovcraft.medsystem.common.init.MedSystemDataAttachments;
import tnt.tarkovcraft.medsystem.common.init.MedSystemStatusEffects;
import tnt.tarkovcraft.medsystem.common.init.MedSystemTags;
import tnt.tarkovcraft.medsystem.common.status.BloodStatus;
import tnt.tarkovcraft.medsystem.common.status.BloodSystem;
import tnt.tarkovcraft.medsystem.network.message.S2C_RefreshEntityDimensions;

public final class BloodData {
    public static final MapCodec<BloodData> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("maxBloodVolume").forGetter(t -> Float.valueOf(t.maxBloodVolume)), (App)Codec.FLOAT.fieldOf("bloodVolume").forGetter(t -> Float.valueOf(t.bloodVolume)), (App)Codec.INT.optionalFieldOf("unconsciousTime", (Object)0).forGetter(t -> t.unconsciousTime), (App)UnconsciousInfo.CODEC.optionalFieldOf("unconsciousInfo", (Object)UnconsciousInfo.EMPTY).forGetter(t -> t.unconsciousInfo)).apply((Applicative)instance, BloodData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BloodData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, t -> Float.valueOf(t.maxBloodVolume), (StreamCodec)ByteBufCodecs.FLOAT, t -> Float.valueOf(t.bloodVolume), (StreamCodec)ByteBufCodecs.INT, t -> t.unconsciousTime, UnconsciousInfo.STREAM_CODEC, t -> t.unconsciousInfo, BloodData::new);
    public static final Identifier ATTR_UNCONSCIOUS = MedicalSystem.createIdentifier("unconscious");
    public static final Identifier ATTR_DEBUFF = MedicalSystem.createIdentifier("blood_debuff");
    public static final UUID UUID_DEBUFF = UUID.fromString("6079d919-84b8-4e8b-9639-bbfd8d313ee1");
    public static final EntityDimensions PLAYER_UNCONSCIOUS_DIMENSIONS = EntityDimensions.scalable((float)1.4f, (float)0.4f);
    private final float maxBloodVolume;
    private float bloodVolume;
    private int unconsciousTime;
    private boolean changed;
    private UnconsciousInfo unconsciousInfo;

    public BloodData(float maxBloodVolume) {
        this(maxBloodVolume, maxBloodVolume, 0, UnconsciousInfo.EMPTY);
    }

    private BloodData(float maxBloodVolume, float bloodVolume, int unconsciousTime, UnconsciousInfo unconsciousInfo) {
        this.maxBloodVolume = maxBloodVolume;
        this.bloodVolume = bloodVolume;
        this.unconsciousTime = unconsciousTime;
        this.unconsciousInfo = unconsciousInfo;
    }

    public void update(LivingEntity entity) {
        long time;
        Level level = entity.level();
        this.updateConsciousStatus(entity, false);
        if (this.changed) {
            this.updateEffects(entity);
            entity.refreshDimensions();
            S2C_RefreshEntityDimensions.broadcast(entity);
            this.changed = false;
            this.sync(entity);
        }
        if ((time = level.getGameTime()) % 20L == 0L) {
            this.bloodLevelTick(entity);
        }
        if (this.isUnconscious() && --this.unconsciousTime <= 0) {
            BloodEvent.OnWakeUp onWakeUp = (BloodEvent.OnWakeUp)NeoForge.EVENT_BUS.post((Event)new BloodEvent.OnWakeUp(entity, this));
            UnconsciousInfo info = onWakeUp.getUnconsciousInfo();
            if (info.causesDeath()) {
                BloodSystem.causeBloodLoss(entity, Float.MAX_VALUE);
            } else if (onWakeUp.willWakeUp()) {
                this.updateEffects(entity);
                this.updateConsciousStatus(entity, true);
            } else {
                this.setUnconsciousTime(onWakeUp.getUnconsciousTime(), info);
                this.sync(entity);
            }
        }
    }

    public float getBloodVolume() {
        return this.bloodVolume;
    }

    public float getBloodVolumePercentage() {
        return Mth.clamp((float)(this.bloodVolume / this.maxBloodVolume), (float)0.0f, (float)1.0f);
    }

    public float getMaxBloodVolume() {
        return this.maxBloodVolume;
    }

    public float getMissingBloodVolume() {
        return this.maxBloodVolume - this.bloodVolume;
    }

    public boolean hasFullBloodVolume() {
        return this.bloodVolume >= this.maxBloodVolume;
    }

    public boolean isUnconscious() {
        return this.unconsciousTime > 0;
    }

    public int getRemainingUnconsciousTime() {
        return this.unconsciousTime;
    }

    public UnconsciousInfo getUnconsciousInfo() {
        return this.unconsciousInfo;
    }

    public void setUnconsciousTime(int unconsciousTime, UnconsciousInfo info) {
        this.unconsciousTime = unconsciousTime;
        this.unconsciousInfo = info;
        this.changed = true;
    }

    public void setOrExtendedUnconsciousTime(int unconsciousTime, UnconsciousInfo info) {
        if (this.isUnconscious() && this.unconsciousInfo.causesDeath()) {
            return;
        }
        this.setUnconsciousTime(Math.max(this.unconsciousTime, unconsciousTime), info);
    }

    public void setBloodVolume(float bloodVolume) {
        this.bloodVolume = Mth.clamp((float)bloodVolume, (float)0.0f, (float)this.maxBloodVolume);
        this.changed = true;
    }

    public float extract(float requested) {
        float extractionAmount = Math.min(this.bloodVolume, requested);
        this.setBloodVolume(this.bloodVolume - extractionAmount);
        return extractionAmount;
    }

    public float insert(float requested) {
        float insertionAmount = Math.min(this.getMissingBloodVolume(), requested);
        this.setBloodVolume(this.bloodVolume + insertionAmount);
        return insertionAmount;
    }

    public void updateEffects(LivingEntity entity) {
        if (entity.level().isClientSide() || !entity.isAlive()) {
            return;
        }
        HealthContainer container = HealthSystem.getHealthData(entity);
        ServerLevel level = (ServerLevel)entity.level();
        float value = this.getBloodVolumePercentage();
        BloodStatus status = BloodStatus.fromBloodLevelPercentage(value);
        status.applyEffects(this, entity, level, container);
        NeoForge.EVENT_BUS.post((Event)new BloodEvent.BloodEffectsTick(entity, this, status, value));
    }

    public void sync(LivingEntity entity) {
        if (entity.isAlive()) {
            entity.syncData(MedSystemDataAttachments.BLOOD_DATA);
        }
    }

    private void bloodLevelTick(LivingEntity entity) {
        float bloodRecoverySpeed;
        if (this.bloodVolume >= this.maxBloodVolume) {
            return;
        }
        HealthContainer container = HealthSystem.getHealthData(entity);
        boolean bleeding = container.hasMatchingStatusEffect(MedSystemTags.StatusEffects.IS_BLEED);
        boolean changed = false;
        if (!bleeding && (bloodRecoverySpeed = AttributeSystem.getFloatValue((Entity)entity, MedSystemAttributes.BLOOD_REGENERATION_AMOUNT, (float)0.0f)) > 0.0f) {
            changed = true;
            this.setBloodVolume(this.bloodVolume + bloodRecoverySpeed);
        }
        if (changed) {
            this.updateEffects(entity);
        }
    }

    public void onDeathBloodLevel(LivingEntity entity, ServerLevel level, HealthContainer container) {
        StatusEffect effect = container.getStatusEffectStream().filter(statusEffect -> statusEffect.getType().is(MedSystemTags.StatusEffects.IS_BLEED)).findAny().orElse(null);
        RegistryAccess access = level.registryAccess();
        if (effect != null) {
            entity.hurtServer(level, MedSystemDamageTypes.causeBleedDamage(access, effect.getCausingEntity(level)), 4.0f);
        } else {
            entity.hurtServer(level, MedSystemDamageTypes.causeBleedDamage(access, Optional.empty()), 4.0f);
        }
        this.addBloodLossStatusEffect(container, entity, false);
        this.setOrExtendedUnconsciousTime(300, UnconsciousInfo.LOW_BLOOD_LEVEL);
    }

    public void onUnconsciousBloodLevel(LivingEntity entity, ServerLevel level, HealthContainer container) {
        this.addBloodLossStatusEffect(container, entity, false);
        this.setOrExtendedUnconsciousTime(100, UnconsciousInfo.LOW_BLOOD_LEVEL);
        MedSystemConfig config = MedicalSystem.getConfig();
        UnconsciousMode mode = config.unconsciousMode;
        if (!mode.allowsUnconsciousState(level)) {
            this.onDeathBloodLevel(entity, level, container);
        }
    }

    public void onRandomBlackoutBloodLevel(LivingEntity entity, ServerLevel level, HealthContainer container) {
        this.addBloodLossStatusEffect(container, entity, false);
        float chance = AttributeSystem.getFloatValue((Entity)entity, MedSystemAttributes.RANDOM_BLACKOUT_CHANCE, (float)0.05f);
        RandomSource random = level.getRandom();
        if (!this.isUnconscious() && chance > 0.0f && random.nextFloat() < chance) {
            this.setOrExtendedUnconsciousTime(100 + random.nextInt(200), UnconsciousInfo.RANDOM_UNCONSCIOUSNESS);
        }
        AttributeMap map = entity.getAttributes();
        this.addModifier(map, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, ATTR_DEBUFF, -0.3f, true);
        AttributeSystem.addModifier((Entity)entity, (Holder)CoreAttributes.WEIGHT_LIMIT, (AttributeModifier)AttributeModifier.multiplier((UUID)UUID_DEBUFF, (double)0.5), (boolean)true);
    }

    public void onModerateBloodLoss(LivingEntity entity, ServerLevel level, HealthContainer container) {
        this.addBloodLossStatusEffect(container, entity, false);
        AttributeMap map = entity.getAttributes();
        this.addModifier(map, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, ATTR_DEBUFF, -0.2f, true);
        AttributeSystem.addModifier((Entity)entity, (Holder)CoreAttributes.WEIGHT_LIMIT, (AttributeModifier)AttributeModifier.multiplier((UUID)UUID_DEBUFF, (double)0.75), (boolean)true);
    }

    public void onMildBloodLoss(LivingEntity entity, ServerLevel level, HealthContainer container) {
        this.addBloodLossStatusEffect(container, entity, true);
        AttributeMap map = entity.getAttributes();
        this.addModifier(map, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, ATTR_DEBUFF, -0.1f, true);
        AttributeSystem.addModifier((Entity)entity, (Holder)CoreAttributes.WEIGHT_LIMIT, (AttributeModifier)AttributeModifier.multiplier((UUID)UUID_DEBUFF, (double)0.9), (boolean)true);
    }

    public void onClearDebuffData(LivingEntity entity, ServerLevel level, HealthContainer container) {
        AttributeMap map = entity.getAttributes();
        this.removeModifier(map, ATTR_DEBUFF, (Holder<Attribute>)Attributes.MOVEMENT_SPEED);
        AttributeSystem.removeModifier((Entity)entity, (Holder)CoreAttributes.WEIGHT_LIMIT, (UUID)UUID_DEBUFF);
    }

    private void addBloodLossStatusEffect(HealthContainer container, LivingEntity entity, boolean mild) {
        StatusEffectHelper.addEffect(container.getGlobalStatusEffects(), entity, null, mild ? new MildBloodLossStatusEffect() : new ModerateBloodLossStatusEffect());
        HealthSystem.synchronizeEntity(entity);
    }

    private void updateConsciousStatus(LivingEntity entity, boolean wakeUp) {
        if (!entity.isAlive()) {
            return;
        }
        boolean unconscious = this.isUnconscious();
        HealthContainer container = HealthSystem.getHealthData(entity);
        StatusEffectMap effects = container.getGlobalStatusEffects();
        AttributeMap attributeMap = entity.getAttributes();
        if (wakeUp) {
            entity.refreshDimensions();
            S2C_RefreshEntityDimensions.broadcast(entity);
        }
        if (unconscious) {
            this.addUnconsciousModifier(attributeMap, (Holder<Attribute>)Attributes.MOVEMENT_SPEED);
            this.addUnconsciousModifier(attributeMap, (Holder<Attribute>)Attributes.JUMP_STRENGTH);
            this.addUnconsciousModifier(attributeMap, (Holder<Attribute>)Attributes.STEP_HEIGHT);
            this.addUnconsciousModifier(attributeMap, (Holder<Attribute>)Attributes.ATTACK_SPEED);
            this.addUnconsciousModifier(attributeMap, (Holder<Attribute>)Attributes.BLOCK_BREAK_SPEED);
            this.addUnconsciousModifier(attributeMap, (Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE);
            if (!effects.hasEffect(MedSystemStatusEffects.UNCONSCIOUS)) {
                StatusEffectHelper.addEffect(effects, entity, null, new UnconsciousStatusEffect());
            }
            if (entity.isUsingItem()) {
                entity.stopUsingItem();
            }
        } else {
            this.removeUnconsciousModifier(attributeMap, (Holder<Attribute>)Attributes.MOVEMENT_SPEED);
            this.removeUnconsciousModifier(attributeMap, (Holder<Attribute>)Attributes.JUMP_STRENGTH);
            this.removeUnconsciousModifier(attributeMap, (Holder<Attribute>)Attributes.STEP_HEIGHT);
            this.removeUnconsciousModifier(attributeMap, (Holder<Attribute>)Attributes.ATTACK_SPEED);
            this.removeUnconsciousModifier(attributeMap, (Holder<Attribute>)Attributes.BLOCK_BREAK_SPEED);
            this.removeUnconsciousModifier(attributeMap, (Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE);
            StatusEffectHelper.removeEffect(StatusEffectSubmitter.NOOP, effects, entity, null, container, MedSystemStatusEffects.UNCONSCIOUS);
        }
    }

    private void addModifier(AttributeMap map, Holder<Attribute> attribute, Identifier id, double value, boolean replace) {
        AttributeInstance instance = map.getInstance(attribute);
        if (!instance.hasModifier(id)) {
            instance.addTransientModifier(new net.minecraft.world.entity.ai.attributes.AttributeModifier(id, value, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        } else if (replace) {
            instance.addOrUpdateTransientModifier(new net.minecraft.world.entity.ai.attributes.AttributeModifier(id, value, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
    }

    private void addUnconsciousModifier(AttributeMap map, Holder<Attribute> attribute) {
        this.addModifier(map, attribute, ATTR_UNCONSCIOUS, -1.0, false);
    }

    private void removeModifier(AttributeMap map, Identifier id, Holder<Attribute> attribute) {
        AttributeInstance instance = map.getInstance(attribute);
        if (instance.hasModifier(id)) {
            instance.removeModifier(id);
        }
    }

    private void removeUnconsciousModifier(AttributeMap map, Holder<Attribute> attribute) {
        this.removeModifier(map, ATTR_UNCONSCIOUS, attribute);
    }

    public record UnconsciousInfo(boolean showGiveUpHint, boolean causesDeath, Component reason) {
        public static final UnconsciousInfo EMPTY = new UnconsciousInfo(true, false, CommonComponents.EMPTY);
        public static final UnconsciousInfo LOW_BLOOD_LEVEL = new UnconsciousInfo(true, false, (Component)Component.translatable((String)"label.medsystem.unconscious.info.low_blood_level"));
        public static final UnconsciousInfo RANDOM_UNCONSCIOUSNESS = new UnconsciousInfo(false, false, (Component)Component.translatable((String)"label.medsystem.unconscious.info.random_unconsciousness"));
        public static final UnconsciousInfo PAIN = new UnconsciousInfo(false, false, (Component)Component.translatable((String)"label.medsystem.unconscious.info.pain"));
        public static final UnconsciousInfo DEATH = new UnconsciousInfo(true, true, (Component)Component.translatable((String)"label.medsystem.unconscious.info.death"));
        public static final Codec<UnconsciousInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("showGiveUpHint").forGetter(UnconsciousInfo::showGiveUpHint), (App)Codec.BOOL.optionalFieldOf("causesDeath", (Object)false).forGetter(UnconsciousInfo::causesDeath), (App)ComponentSerialization.CODEC.fieldOf("reason").forGetter(UnconsciousInfo::reason)).apply((Applicative)instance, UnconsciousInfo::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, UnconsciousInfo> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, UnconsciousInfo::showGiveUpHint, (StreamCodec)ByteBufCodecs.BOOL, UnconsciousInfo::causesDeath, (StreamCodec)ComponentSerialization.STREAM_CODEC, UnconsciousInfo::reason, UnconsciousInfo::new);
    }
}

