/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.api.heal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import tnt.tarkovcraft.core.common.attribute.AttributeSystem;
import tnt.tarkovcraft.core.common.data.duration.Duration;
import tnt.tarkovcraft.core.common.data.duration.DurationFormats;
import tnt.tarkovcraft.core.common.data.duration.DurationFormatter;
import tnt.tarkovcraft.medsystem.MedicalSystem;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffectType;
import tnt.tarkovcraft.medsystem.common.effect.util.EffectType;
import tnt.tarkovcraft.medsystem.common.effect.util.StatusEffectHelper;
import tnt.tarkovcraft.medsystem.common.effect.util.StatusEffectMap;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.Limb;
import tnt.tarkovcraft.medsystem.common.health.LimbType;
import tnt.tarkovcraft.medsystem.common.init.MedSystemAttributes;

public record SideEffect(float chance, int delay, StatusEffect template) implements TooltipProvider
{
    public static final Codec<SideEffect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(t -> Float.valueOf(t.chance)), (App)Codec.INT.optionalFieldOf("delay", (Object)0).forGetter(t -> t.delay), (App)StatusEffectType.CODEC.fieldOf("template").forGetter(t -> t.template)).apply((Applicative)instance, SideEffect::new));

    public void apply(LivingEntity entity, HealthContainer container, @Nullable Limb part) {
        this.applyFromDamage(entity, null, container, part);
    }

    public void applyFromDamage(LivingEntity entity, @Nullable DamageSource damageSource, HealthContainer container, @Nullable Limb part) {
        float effectChance;
        LimbType group;
        StatusEffectType<?> type = this.template.getType();
        if (part != null && !type.isGlobalEffect() && type.isIgnoredBodyPart(group = part.getType())) {
            return;
        }
        RandomSource source = entity.getRandom();
        Holder chanceAttribute = this.chance < 1.0f ? (Holder)type.getEffectType().byValue(MedSystemAttributes.POSITIVE_EFFECT_CHANCE, MedSystemAttributes.NEGATIVE_EFFECT_CHANCE, null) : null;
        float f = effectChance = chanceAttribute != null ? this.chance * AttributeSystem.getFloatValue((Entity)entity, (Holder)chanceAttribute, (float)1.0f) : this.chance;
        if (effectChance >= 1.0f || source.nextFloat() < effectChance) {
            if (!type.isGlobalEffect() && part == null) {
                MedicalSystem.LOGGER.error(MedicalSystem.MARKER, "Failed to apply side effect {} as effect is not set as global, but target body part was not provided", type);
                return;
            }
            StatusEffectMap effects = type.isGlobalEffect() ? container.getGlobalStatusEffects() : part.getStatusEffects();
            StatusEffect statusEffect = this.template.copy();
            if (!this.template.isInfinite()) {
                Holder durationAttribute = type.getEffectType().byValue(MedSystemAttributes.POSITIVE_EFFECT_DURATION, MedSystemAttributes.NEGATIVE_EFFECT_DURATION, null);
                int duration = durationAttribute != null ? Mth.ceil((float)(AttributeSystem.getFloatValue((Entity)entity, (Holder)durationAttribute, (float)1.0f) * (float)this.template.getDuration())) : this.template.getDuration();
                statusEffect.setDuration(duration);
            }
            if (damageSource != null) {
                Entity cause;
                Entity entity2 = cause = damageSource.isDirect() ? damageSource.getDirectEntity() : damageSource.getEntity();
                if (cause != null) {
                    statusEffect.setCausingEntity(cause.getUUID());
                }
            }
            StatusEffectHelper.addEffect(effects, entity, part, this.delay, statusEffect);
        }
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag flag, DataComponentGetter componentGetter) {
        if (this.template.hasCustomTooltip()) {
            this.template.addCustomTooltip(tooltipAdder);
        } else {
            StatusEffectType<?> type = this.template.getType();
            EffectType effectType = type.getEffectType();
            tooltipAdder.accept(SideEffect.createDescriptionComponent(effectType, type.getDisplayName(), this.chance, this.template.getDuration(), this.delay));
        }
    }

    public static Component createDescriptionComponent(EffectType type, Component name, float chance, int duration, int delay) {
        MutableComponent component = Component.literal((String)"> ");
        if (chance < 1.0f) {
            component.append(String.format(Locale.ROOT, "%.1f%%", Float.valueOf(chance * 100.0f)) + " ");
        }
        component.append(name);
        if (duration > 0) {
            component.append(" / ").append((Component)Component.translatable((String)"tooltip.medsystem.heal_attributes.side_effects.duration", (Object[])new Object[]{Duration.format((int)duration, (DurationFormatter)DurationFormats.SHORT_NAME)}));
        }
        if (delay > 0) {
            component.append(" / ").append((Component)Component.translatable((String)"tooltip.medsystem.heal_attributes.side_effects.delay", (Object[])new Object[]{Duration.format((int)delay, (DurationFormatter)DurationFormats.SHORT_NAME)}));
        }
        return component.withStyle((UnaryOperator)type);
    }
}

