/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.client.overlay;

import com.mojang.blaze3d.platform.Window;
import java.util.List;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.client.gui.GuiLayer;
import tnt.tarkovcraft.core.common.data.duration.Duration;
import tnt.tarkovcraft.core.common.data.duration.DurationFormats;
import tnt.tarkovcraft.core.common.data.duration.DurationFormatter;
import tnt.tarkovcraft.medsystem.MedicalSystem;
import tnt.tarkovcraft.medsystem.common.status.BloodData;
import tnt.tarkovcraft.medsystem.common.status.BloodSystem;

public class UnconsciousLayer
implements GuiLayer {
    public static final ResourceLocation LAYER_ID = MedicalSystem.resource("layer/unconscious");

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        Minecraft client = Minecraft.getInstance();
        LocalPlayer player = client.player;
        Font font = client.font;
        if (client.options.hideGui) {
            return;
        }
        if (player.isSpectator()) {
            return;
        }
        Window window = client.getWindow();
        BloodData data = BloodSystem.getBloodData((LivingEntity)player);
        if (data.isUnconscious()) {
            int textWidth;
            BloodData.UnconsciousInfo info = data.getUnconsciousInfo();
            Component reason = info.reason();
            List lines = font.split((FormattedText)reason, window.getGuiScaledWidth() / 3 * 2);
            for (int i = 0; i < lines.size(); ++i) {
                FormattedCharSequence line = (FormattedCharSequence)lines.get(i);
                textWidth = font.width(line);
                guiGraphics.drawString(font, line, (window.getGuiScaledWidth() - textWidth) / 2, 30 + i * 11, -1, true);
            }
            if (info.causesDeath()) {
                Duration timer = Duration.ticks((int)data.getRemainingUnconsciousTime());
                Component text = timer.format((DurationFormatter)DurationFormats.LONG_NAME);
                textWidth = font.width((FormattedText)text);
                guiGraphics.drawString(font, text, (window.getGuiScaledWidth() - textWidth) / 2, 30 + (lines.size() + 1) * 11, -1, true);
            }
        }
    }
}

