/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import tnt.tarkovcraft.core.common.data.duration.Duration;
import tnt.tarkovcraft.medsystem.api.BodyPartDamageSource;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffectType;
import tnt.tarkovcraft.medsystem.common.effect.util.StatusEffectHelper;
import tnt.tarkovcraft.medsystem.common.effect.util.StatusEffectMap;
import tnt.tarkovcraft.medsystem.common.effect.util.StatusEffectSubmitter;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.HealthSystem;
import tnt.tarkovcraft.medsystem.common.health.Limb;
import tnt.tarkovcraft.medsystem.common.init.MedSystemRegistries;
import tnt.tarkovcraft.medsystem.common.status.BloodData;
import tnt.tarkovcraft.medsystem.common.status.BloodSystem;

public final class TarkovCraftCommand {
    private static final SimpleCommandExceptionType NO_VALID_TARGET_FOUND = new SimpleCommandExceptionType((Message)Component.literal((String)"No health containers found for given entity selector"));
    private static final SimpleCommandExceptionType NO_BLOOD_DATA_FOUND = new SimpleCommandExceptionType((Message)Component.literal((String)"No blood data found for given entity"));
    private static final DynamicCommandExceptionType INVALID_STATUS_EFFECT = new DynamicCommandExceptionType(arg -> Component.literal((String)("Status effect " + String.valueOf(arg) + " is not assignable")));

    public static void create(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tarkovcraft").then(((LiteralArgumentBuilder)Commands.literal((String)"effect").requires(src -> src.hasPermission(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.entities()).then(Commands.literal((String)"add").then(Commands.argument((String)"limb", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"type", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, MedSystemRegistries.Keys.STATUS_EFFECT)).executes(ctx -> TarkovCraftCommand.addLocalStatusEffect((CommandContext<CommandSourceStack>)ctx, Duration.seconds((int)60).tickValue(), 0))).then(((LiteralArgumentBuilder)Commands.literal((String)"infinite").executes(ctx -> TarkovCraftCommand.addLocalStatusEffect((CommandContext<CommandSourceStack>)ctx, -1, 0))).then(Commands.argument((String)"delay", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> TarkovCraftCommand.addLocalStatusEffect((CommandContext<CommandSourceStack>)ctx, -1, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"delay")))))).then(((RequiredArgumentBuilder)Commands.argument((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> TarkovCraftCommand.addLocalStatusEffect((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"duration"), 0))).then(Commands.argument((String)"delay", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> TarkovCraftCommand.addLocalStatusEffect((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"duration"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"delay"))))))))).then(Commands.literal((String)"addGlobal").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"type", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, MedSystemRegistries.Keys.STATUS_EFFECT)).executes(ctx -> TarkovCraftCommand.addGlobalStatusEffect((CommandContext<CommandSourceStack>)ctx, Duration.seconds((int)60).tickValue(), 0))).then(((LiteralArgumentBuilder)Commands.literal((String)"infinite").executes(ctx -> TarkovCraftCommand.addGlobalStatusEffect((CommandContext<CommandSourceStack>)ctx, -1, 0))).then(Commands.argument((String)"delay", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> TarkovCraftCommand.addGlobalStatusEffect((CommandContext<CommandSourceStack>)ctx, -1, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"delay")))))).then(((RequiredArgumentBuilder)Commands.argument((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> TarkovCraftCommand.addGlobalStatusEffect((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"duration"), 0))).then(Commands.argument((String)"delay", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> TarkovCraftCommand.addGlobalStatusEffect((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"duration"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"delay")))))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"type", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, MedSystemRegistries.Keys.STATUS_EFFECT)).then(Commands.argument((String)"limb", (ArgumentType)StringArgumentType.word()).executes(TarkovCraftCommand::removeLocalStatusEffect))))).then(Commands.literal((String)"removeGlobal").then(Commands.argument((String)"type", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, MedSystemRegistries.Keys.STATUS_EFFECT)).executes(TarkovCraftCommand::removeGlobalStatusEffect)))))).then(((LiteralArgumentBuilder)Commands.literal((String)"hurt").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).then(Commands.argument((String)"limb", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"damage_type", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, (ResourceKey)Registries.DAMAGE_TYPE)).then(((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)FloatArgumentType.floatArg((float)0.01f)).executes(ctx -> TarkovCraftCommand.hurtLimb((CommandContext<CommandSourceStack>)ctx, null, null))).then(((RequiredArgumentBuilder)Commands.argument((String)"causing_entity", (ArgumentType)EntityArgument.entity()).executes(ctx -> TarkovCraftCommand.hurtLimb((CommandContext<CommandSourceStack>)ctx, EntityArgument.getEntity((CommandContext)ctx, (String)"causing_entity"), null))).then(Commands.argument((String)"direct_entity", (ArgumentType)EntityArgument.entity()).executes(ctx -> TarkovCraftCommand.hurtLimb((CommandContext<CommandSourceStack>)ctx, EntityArgument.getEntity((CommandContext)ctx, (String)"causing_entity"), EntityArgument.getEntity((CommandContext)ctx, (String)"direct_entity"))))))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"blood").requires(src -> src.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).executes(TarkovCraftCommand::getBloodInfo)).then(Commands.argument((String)"volume", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(TarkovCraftCommand::setBloodVolume))))).then(((LiteralArgumentBuilder)Commands.literal((String)"unconscious").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).then(Commands.argument((String)"time", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(TarkovCraftCommand::setUnconsciousState)))));
    }

    private static int addGlobalStatusEffect(CommandContext<CommandSourceStack> ctx, int duration, int delay) throws CommandSyntaxException {
        Holder.Reference reference = ResourceArgument.getResource(ctx, (String)"type", MedSystemRegistries.Keys.STATUS_EFFECT);
        Collection entities = EntityArgument.getEntities(ctx, (String)"target");
        for (Entity entity : entities) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !HealthSystem.hasCustomHealth((Entity)(livingEntity = (LivingEntity)entity))) continue;
            HealthContainer container = HealthSystem.getHealthData(livingEntity);
            StatusEffectMap map = container.getGlobalStatusEffects();
            TarkovCraftCommand.addEffect(map, livingEntity, null, container, reference, duration, delay);
            HealthSystem.synchronizeEntity(livingEntity);
        }
        return 0;
    }

    private static int addLocalStatusEffect(CommandContext<CommandSourceStack> ctx, int duration, int delay) throws CommandSyntaxException {
        Holder.Reference reference = ResourceArgument.getResource(ctx, (String)"type", MedSystemRegistries.Keys.STATUS_EFFECT);
        String bodyPartId = StringArgumentType.getString(ctx, (String)"limb");
        Collection entities = EntityArgument.getEntities(ctx, (String)"target");
        for (Entity entity : entities) {
            HealthContainer container;
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !HealthSystem.hasCustomHealth((Entity)(livingEntity = (LivingEntity)entity)) || !(container = HealthSystem.getHealthData(livingEntity)).hasLimb(bodyPartId)) continue;
            Limb limb = container.getLimb(bodyPartId);
            StatusEffectMap map = limb.getStatusEffects();
            TarkovCraftCommand.addEffect(map, livingEntity, limb, container, reference, duration, delay);
            HealthSystem.synchronizeEntity(livingEntity);
        }
        return 0;
    }

    private static <T extends StatusEffect> void addEffect(StatusEffectMap map, LivingEntity entity, @Nullable Limb limb, HealthContainer container, Holder<StatusEffectType<?>> holder, int duration, int delay) throws CommandSyntaxException {
        StatusEffectType type = (StatusEffectType)holder.value();
        if (type.isSpecialStatusEffect()) {
            throw INVALID_STATUS_EFFECT.create((Object)holder.getKey().location());
        }
        StatusEffectHelper.removeEffect(StatusEffectSubmitter.NOOP, map, entity, limb, container, (StatusEffectType)holder.value());
        StatusEffectHelper.addEffect(map, entity, limb, delay, type.createEffect(duration));
    }

    private static int removeGlobalStatusEffect(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Holder.Reference reference = ResourceArgument.getResource(ctx, (String)"type", MedSystemRegistries.Keys.STATUS_EFFECT);
        StatusEffectType type = (StatusEffectType)reference.value();
        if (type.isSpecialStatusEffect()) {
            throw INVALID_STATUS_EFFECT.create((Object)reference.getKey().location());
        }
        Collection entities = EntityArgument.getEntities(ctx, (String)"target");
        for (Entity entity : entities) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !HealthSystem.hasCustomHealth((Entity)(livingEntity = (LivingEntity)entity))) continue;
            HealthContainer container = HealthSystem.getHealthData(livingEntity);
            StatusEffectMap map = container.getGlobalStatusEffects();
            StatusEffectHelper.removeEffect(StatusEffectSubmitter.NOOP, map, livingEntity, null, container, type);
            HealthSystem.synchronizeEntity(livingEntity);
        }
        return 0;
    }

    private static int removeLocalStatusEffect(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Holder.Reference reference = ResourceArgument.getResource(ctx, (String)"type", MedSystemRegistries.Keys.STATUS_EFFECT);
        StatusEffectType type = (StatusEffectType)reference.value();
        if (type.isSpecialStatusEffect()) {
            throw INVALID_STATUS_EFFECT.create((Object)reference.getKey().location());
        }
        String bodyPartId = StringArgumentType.getString(ctx, (String)"limb");
        Collection entities = EntityArgument.getEntities(ctx, (String)"target");
        for (Entity entity : entities) {
            HealthContainer container;
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !HealthSystem.hasCustomHealth((Entity)(livingEntity = (LivingEntity)entity)) || !(container = HealthSystem.getHealthData(livingEntity)).hasLimb(bodyPartId)) continue;
            Limb limb = container.getLimb(bodyPartId);
            StatusEffectMap map = limb.getStatusEffects();
            StatusEffectHelper.removeEffect(StatusEffectSubmitter.NOOP, map, livingEntity, limb, container, type);
            HealthSystem.synchronizeEntity(livingEntity);
        }
        return 0;
    }

    private static int hurtLimb(CommandContext<CommandSourceStack> ctx, Entity source, Entity projectile) throws CommandSyntaxException {
        Collection targets = EntityArgument.getEntities(ctx, (String)"targets");
        List<LivingEntity> entities = targets.stream().filter(HealthSystem::hasCustomHealth).map(entity -> (LivingEntity)entity).toList();
        if (entities.isEmpty()) {
            throw NO_VALID_TARGET_FOUND.create();
        }
        Holder.Reference damageTypeHolder = ResourceArgument.getResource(ctx, (String)"damage_type", (ResourceKey)Registries.DAMAGE_TYPE);
        String limb = StringArgumentType.getString(ctx, (String)"limb");
        float amount = FloatArgumentType.getFloat(ctx, (String)"amount");
        BodyPartDamageSource damageSource = new BodyPartDamageSource((Holder<DamageType>)damageTypeHolder, projectile, source, limb);
        for (LivingEntity entity2 : entities) {
            entity2.hurtServer((ServerLevel)entity2.level(), (DamageSource)damageSource, amount);
        }
        return 0;
    }

    private static int getBloodInfo(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        LivingEntity livingEntity;
        Entity entity = EntityArgument.getEntity(ctx, (String)"target");
        if (!(entity instanceof LivingEntity) || !BloodSystem.hasBloodDataIntegration(livingEntity = (LivingEntity)entity)) {
            throw NO_BLOOD_DATA_FOUND.create();
        }
        BloodData data = BloodSystem.getBloodData(livingEntity);
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        source.sendSystemMessage((Component)Component.literal((String)(entity.getDisplayName().getString() + " blood: " + String.format(Locale.ROOT, "%.4f/%.2fL", Float.valueOf(data.getBloodVolume()), Float.valueOf(data.getMaxBloodVolume())))));
        return 0;
    }

    private static int setBloodVolume(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        LivingEntity livingEntity;
        Entity entity = EntityArgument.getEntity(ctx, (String)"target");
        if (!(entity instanceof LivingEntity) || !BloodSystem.hasBloodDataIntegration(livingEntity = (LivingEntity)entity)) {
            throw NO_BLOOD_DATA_FOUND.create();
        }
        BloodData data = BloodSystem.getBloodData(livingEntity);
        float volume = FloatArgumentType.getFloat(ctx, (String)"volume");
        data.setBloodVolume(volume);
        data.sync(livingEntity);
        return 0;
    }

    private static int setUnconsciousState(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        LivingEntity livingEntity;
        Entity entity = EntityArgument.getEntity(ctx, (String)"target");
        if (!(entity instanceof LivingEntity) || !BloodSystem.hasBloodDataIntegration(livingEntity = (LivingEntity)entity)) {
            throw NO_BLOOD_DATA_FOUND.create();
        }
        BloodData data = BloodSystem.getBloodData(livingEntity);
        int time = IntegerArgumentType.getInteger(ctx, (String)"time");
        data.setUnconsciousTime(time, BloodData.UnconsciousInfo.EMPTY);
        data.sync(livingEntity);
        return 0;
    }
}

