/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.health;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.util.ExtraCodecs;
import tnt.tarkovcraft.core.util.Codecs;
import tnt.tarkovcraft.medsystem.common.health.Limb;
import tnt.tarkovcraft.medsystem.common.health.LimbType;
import tnt.tarkovcraft.medsystem.common.health.reaction.ReactionDefinition;

public final class LimbDefinition {
    public static final Codec<LimbDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("vital", (Object)false).forGetter(t -> t.vital), (App)Codec.STRING.optionalFieldOf("parent").forGetter(t -> Optional.ofNullable(t.parent)), (App)Codec.floatRange((float)0.0f, (float)10.0f).optionalFieldOf("parentDamageScale", (Object)Float.valueOf(1.0f)).forGetter(t -> Float.valueOf(t.parentDamageScale)), (App)Codec.floatRange((float)0.0f, (float)10.0f).optionalFieldOf("damageScale", (Object)Float.valueOf(1.0f)).forGetter(t -> Float.valueOf(t.damageScale)), (App)ExtraCodecs.POSITIVE_FLOAT.fieldOf("health").forGetter(t -> Float.valueOf(t.maxHealth)), (App)Codecs.enumCodec(LimbType.class).optionalFieldOf("group", (Object)LimbType.OTHER).forGetter(t -> t.limbType), (App)Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, ReactionDefinition.CODEC).optionalFieldOf("reactions", Collections.emptyMap()).forGetter(t -> t.reactions)).apply((Applicative)instance, LimbDefinition::new));
    private final boolean vital;
    @Nullable
    private final String parent;
    private final float parentDamageScale;
    private final float damageScale;
    private final float maxHealth;
    private final LimbType limbType;
    private final Map<UUID, ReactionDefinition> reactions;

    public LimbDefinition(boolean vital, Optional<String> parent, float parentDamageScale, float damageScale, float maxHealth, LimbType limbType, Map<UUID, ReactionDefinition> reactions) {
        this.vital = vital;
        this.parent = parent.orElse(null);
        this.parentDamageScale = parentDamageScale;
        this.damageScale = damageScale;
        this.maxHealth = maxHealth;
        this.limbType = limbType;
        this.reactions = reactions;
    }

    @Nullable
    public String getParent() {
        return this.parent;
    }

    public boolean isVital() {
        return this.vital;
    }

    public float getMaxHealth() {
        return this.maxHealth;
    }

    public float getParentDamageScale() {
        return this.parentDamageScale;
    }

    public float getDamageScale() {
        return this.damageScale;
    }

    public Limb createLimbInstance(String code) {
        Limb part = new Limb(code, this.vital, this.maxHealth, this.parentDamageScale, this.damageScale, this.limbType);
        part.setDefinition(this);
        return part;
    }

    public Collection<ReactionDefinition> getReactions() {
        return this.reactions.values();
    }

    Map<UUID, ReactionDefinition> getReactionMap() {
        return this.reactions;
    }

    public LimbType getBodyPartGroup() {
        return this.limbType;
    }
}

