/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.skill.tracker.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import tnt.tarkovcraft.core.common.init.CoreSkillTriggerConditions;
import tnt.tarkovcraft.core.common.skill.SkillContext;
import tnt.tarkovcraft.core.common.skill.tracker.condition.SkillTriggerCondition;
import tnt.tarkovcraft.core.common.skill.tracker.condition.SkillTriggerConditionType;

public class IsSprintingSkillTriggerCondition
implements SkillTriggerCondition {
    public static final MapCodec<IsSprintingSkillTriggerCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("invert", (Object)false).forGetter(t -> t.invert)).apply((Applicative)instance, IsSprintingSkillTriggerCondition::new));
    private final boolean invert;

    public IsSprintingSkillTriggerCondition(boolean invert) {
        this.invert = invert;
    }

    @Override
    public boolean isTriggerable(SkillContext context) {
        Entity entity = context.entity();
        boolean sprinting = entity.isSprinting();
        return this.invert != sprinting;
    }

    @Override
    public Component getDescription() {
        return this.invert ? Component.translatable((String)"skill.condition.not_sprinting") : Component.translatable((String)"skill.condition.sprinting");
    }

    @Override
    public SkillTriggerConditionType<?> getType() {
        return CoreSkillTriggerConditions.IS_SPRINTING.get();
    }
}

