/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.screen;

import dev.toma.configuration.Configuration;
import dev.toma.configuration.client.screen.AbstractConfigScreen;
import dev.toma.configuration.client.theme.ConfigTheme;
import dev.toma.configuration.client.theme.adapter.DisplayAdapter;
import dev.toma.configuration.client.widget.ConfigEntryWidget;
import dev.toma.configuration.client.widget.ThemedButtonWidget;
import dev.toma.configuration.client.widget.render.TextureRenderer;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.adapter.TypeAdapterManager;
import dev.toma.configuration.config.value.AbstractArrayValue;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.ValueData;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

public class ArrayConfigScreen<V, C extends AbstractArrayValue<V>>
extends AbstractConfigScreen {
    public static final Component ADD_ELEMENT = Component.translatable((String)"text.configuration.value.add_element");
    public static final ResourceLocation REMOVE_ICON = ResourceLocation.fromNamespaceAndPath((String)"configuration", (String)"textures/icons/remove.png");
    public final C array;
    private final boolean fixedSize;
    private Supplier<Integer> sizeSupplier = () -> 0;
    private DummyConfigValueFactory valueFactory;
    private ElementAddHandler addHandler;
    private ElementRemoveHandler<V[]> removeHandler;

    public ArrayConfigScreen(ConfigHolder<?> holder, C array, Screen previous) {
        super(((ConfigValue)array).getValueData().getTitle(), previous, holder);
        this.array = array;
        this.fixedSize = ((AbstractArrayValue)array).isFixedSize();
    }

    public void fetchSize(Supplier<Integer> integerSupplier) {
        this.sizeSupplier = integerSupplier;
    }

    public void valueFactory(DummyConfigValueFactory factory) {
        this.valueFactory = factory;
    }

    public void addElement(ElementAddHandler handler) {
        this.addHandler = handler;
    }

    public void removeElement(ElementRemoveHandler<V[]> handler) {
        this.removeHandler = handler;
    }

    protected void init() {
        int viewportMin = 35;
        int viewportHeight = this.height - 35 - 30;
        int spacing = 22;
        this.pageSize = (viewportHeight - 20) / spacing;
        this.correctScrollingIndex(this.getTotalSize());
        int errorOffset = viewportHeight - 20 - (this.pageSize * spacing - 5);
        int offset = 0;
        Class<?> compType = ((Object[])((ConfigValue)this.array).get()).getClass().getComponentType();
        DisplayAdapter adapter = this.theme.getAdapter(compType);
        TypeAdapter.AdapterContext context = ((ConfigValue)this.array).getSerializationContext();
        Field owner = context.getOwner();
        for (int i = this.index; i < this.index + this.pageSize; ++i) {
            int j = i - this.index;
            if (i >= this.sizeSupplier.get()) {
                if (this.fixedSize) break;
                ThemedButtonWidget addElement = (ThemedButtonWidget)this.addRenderableWidget((GuiEventListener)new ThemedButtonWidget(30, 45 + j * spacing + offset, this.width - 60, 20, ADD_ELEMENT, this.theme));
                addElement.setBackgroundRenderer(this.theme.getButtonBackground(addElement));
                addElement.setClickListener((widget, mouseX, mouseY) -> {
                    this.addHandler.insertElement();
                    this.init(this.minecraft, this.width, this.height);
                });
                break;
            }
            int correct = errorOffset / (this.pageSize - j);
            errorOffset -= correct;
            ConfigValue<?> dummy = this.valueFactory.create(((ConfigValue)this.array).getId(), i);
            dummy.processAnnotations(owner);
            Component label = this.getEntryLabel(dummy, i);
            ConfigEntryWidget widget2 = (ConfigEntryWidget)this.addRenderableWidget((GuiEventListener)new ConfigEntryWidget(30, 45 + j * spacing + (offset += correct), this.width - 60, 20, label, dummy, this.getConfigId(), this.theme));
            widget2.setDescriptionRenderer(this);
            if (adapter == null) {
                Configuration.LOGGER.error(MARKER, "Missing display adapter for {} type, will not be displayed in GUI", (Object)compType.getSimpleName());
                continue;
            }
            try {
                adapter.placeWidgets(this.holder, dummy, owner, this.theme, widget2);
            }
            catch (ClassCastException e) {
                Configuration.LOGGER.error(MARKER, (Message)new FormattedMessage("Unable to create config field for {}", (Object)compType.getSimpleName()), (Throwable)e);
            }
            if (this.fixedSize) continue;
            int elementIndex = i;
            ThemedButtonWidget removeButton = (ThemedButtonWidget)this.addRenderableWidget((GuiEventListener)new ThemedButtonWidget(this.width - 29, widget2.getY(), 20, 20, CommonComponents.EMPTY, this.theme));
            removeButton.setClickListener((widget1, mouseX, mouseY) -> {
                this.removeHandler.removeElementAt(elementIndex, (index1, src, dest) -> {
                    System.arraycopy(src, 0, dest, 0, index1);
                    System.arraycopy(src, index1 + 1, dest, index1, this.sizeSupplier.get() - 1 - index1);
                    return dest;
                });
                this.init(this.minecraft, this.width, this.height);
            });
            removeButton.setBackgroundRenderer(this.theme.getButtonBackground(removeButton));
            removeButton.setForegroundRenderer(new TextureRenderer(REMOVE_ICON, 2, 2, 16, 16));
        }
        this.addSettingsButton();
        this.addFooter();
    }

    private <T> Component getEntryLabel(ConfigValue<T> value, int index) {
        ValueData<T> valueData = value.getValueData();
        String languageKey = valueData.getLanguageKey(valueData.getAttributes()) + ".entry";
        MutableComponent translated = Component.translatable((String)languageKey);
        return Component.literal((String)("[" + index + "] " + translated.getString()));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (ArrayConfigScreen.canRenderBackground(this.minecraft)) {
            ConfigTheme.Header themeHeader = this.theme.getHeader();
            ConfigTheme.Footer footer = this.theme.getFooter();
            Component headerLabel = themeHeader.customText() != null ? themeHeader.customText() : this.title;
            int titleWidth = this.font.width((FormattedText)headerLabel);
            graphics.fill(0, 0, this.width, 35, themeHeader.backgroundColor());
            int n = (this.width - titleWidth) / 2;
            Objects.requireNonNull(this.font);
            graphics.drawString(this.font, headerLabel, n, (35 - 9) / 2, themeHeader.foregroundColor());
            graphics.fill(0, this.height - 30, this.width, this.height, footer.backgroundColor());
            Integer fillColor = this.theme.getBackgroundFillColor();
            if (fillColor != null) {
                graphics.fill(0, 35, this.width, this.height - 30, fillColor.intValue());
            }
        }
        this.renderables.forEach(renderable -> renderable.render(graphics, mouseX, mouseY, partialTicks));
        ConfigTheme.Scrollbar scrollbar = this.theme.getScrollbar();
        ArrayConfigScreen.renderScrollbar(graphics, this.width - scrollbar.width(), 35, scrollbar.width(), this.height - 30 - 35, this.index, this.getTotalSize(), this.pageSize, scrollbar.backgroundColor());
        this.renderPost(graphics, partialTicks);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        int scale = (int)(-amountY);
        int next = this.index + scale;
        if (next >= 0 && next + this.pageSize <= this.getTotalSize()) {
            this.index = next;
            this.init(this.minecraft, this.width, this.height);
            return true;
        }
        return false;
    }

    private int getTotalSize() {
        int elementSize = this.sizeSupplier.get();
        if (!this.fixedSize) {
            ++elementSize;
        }
        return elementSize;
    }

    public static <V> TypeAdapter.AdapterContext callbackCtx(Field parent, Class<V> componentType, BiConsumer<V, Integer> callback, int index) {
        return new DummyCallbackAdapter<V>(componentType, parent, callback, index);
    }

    @FunctionalInterface
    public static interface DummyConfigValueFactory {
        public ConfigValue<?> create(String var1, int var2);
    }

    @FunctionalInterface
    public static interface ElementAddHandler {
        public void insertElement();
    }

    @FunctionalInterface
    public static interface ElementRemoveHandler<V> {
        public void removeElementAt(int var1, ArrayTrimmer<V> var2);

        @FunctionalInterface
        public static interface ArrayTrimmer<V> {
            public V trim(int var1, V var2, V var3);
        }
    }

    private static class DummyCallbackAdapter<V>
    implements TypeAdapter.AdapterContext {
        private final TypeAdapter<?> typeAdapter;
        private final Field parentField;
        private final BiConsumer<V, Integer> setCallback;
        private final int index;

        private DummyCallbackAdapter(Class<V> type, Field parentField, BiConsumer<V, Integer> setCallback, int index) {
            this.typeAdapter = TypeAdapterManager.forType(type).adapter();
            this.parentField = parentField;
            this.setCallback = setCallback;
            this.index = index;
        }

        @Override
        public TypeAdapter<?> getAdapter() {
            return this.typeAdapter;
        }

        @Override
        public Field getOwner() {
            return this.parentField;
        }

        @Override
        public void setFieldValue(Object value) {
            this.setCallback.accept(value, this.index);
        }

        @Override
        public void setValue(Object value) {
            this.setCallback.accept(value, this.index);
        }
    }
}

