/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.screen;

import dev.toma.configuration.Configuration;
import dev.toma.configuration.ConfigurationOptions;
import dev.toma.configuration.config.io.ConfigurationFileManager;
import dev.toma.configuration.config.value.BooleanValue;
import java.time.Duration;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public final class ConfigSettingsScreen
extends Screen {
    private static final Component TITLE = Component.translatable((String)"options.title");
    private final Screen parent;

    public ConfigSettingsScreen(Screen parent) {
        super(TITLE);
        this.parent = parent;
    }

    public void onClose() {
        super.onClose();
        this.close();
    }

    protected void init() {
        ConfigurationOptions options = Configuration.options.getConfigInstance();
        Checkbox advancedMode = (Checkbox)this.addRenderableWidget((GuiEventListener)Checkbox.builder((Component)Component.translatable((String)"text.configuration.options.advanced_mode"), (Font)this.font).pos(10, 40).maxWidth(this.width - 20).selected(options.advancedMode).onValueChange((checkbox1, b) -> Configuration.options.getConfigValue("advancedMode", Boolean.class).ifPresent(value -> ((BooleanValue)value).forceSetValue(b))).tooltip(Tooltip.create((Component)Component.translatable((String)"text.configuration.options.advanced_mode.tooltip"))).build());
        advancedMode.setTooltipDelay(Duration.ofMillis(500L));
        Checkbox hideBackground = (Checkbox)this.addRenderableWidget((GuiEventListener)Checkbox.builder((Component)Component.translatable((String)"text.configuration.options.hide_background"), (Font)this.font).pos(10, 60).maxWidth(this.width - 20).selected(options.hideBackground).onValueChange((checkbox1, b) -> Configuration.options.getConfigValue("hideBackground", Boolean.class).ifPresent(value -> ((BooleanValue)value).forceSetValue(b))).tooltip(Tooltip.create((Component)Component.translatable((String)"text.configuration.options.hide_background.tooltip"))).build());
        hideBackground.setTooltipDelay(Duration.ofMillis(500L));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.back"), button -> this.close()).pos(5, this.height - 25).size(120, 20).build());
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float renderDelta) {
        super.renderBackground(graphics, mouseX, mouseY, renderDelta);
        graphics.fill(0, 0, this.width, 30, -1728053248);
        graphics.fill(0, this.height - 30, this.width, this.height, -1728053248);
        int n = (this.width - this.font.width((FormattedText)TITLE)) / 2;
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, TITLE, n, (30 - 9) / 2, -1);
    }

    private void close() {
        ConfigurationFileManager.saveClientValues(Configuration.options);
        this.minecraft.setScreen(this.parent);
    }
}

