/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config;

import dev.toma.configuration.Configuration;
import dev.toma.configuration.client.widget.EditBoxWidget;
import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.exception.ConfigValueMissingException;
import dev.toma.configuration.config.io.ConfigurationFileManager;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ConfigUtils {
    public static void logCorrectedMessage(String field, Object prevValue, Object corrected) {
        Configuration.LOGGER.warn(ConfigurationFileManager.MARKER, "Correcting config value '{}' from '{}' to '{}'", (Object)field, (Object)Objects.toString(prevValue), corrected);
    }

    public static void logArraySizeCorrectedMessage(String field, Object prevValue, Object corrected) {
        Configuration.LOGGER.warn(ConfigurationFileManager.MARKER, "Correcting config array value '{}' due to invalid size from '{}' to '{}'", (Object)field, prevValue, corrected);
    }

    public static <E extends Enum<E>> E getEnumConstant(String value, Class<E> declaringClass) throws ConfigValueMissingException {
        Enum[] constants;
        for (Enum e : constants = (Enum[])declaringClass.getEnumConstants()) {
            if (!e.name().equals(value)) continue;
            return (E)e;
        }
        throw new ConfigValueMissingException("Missing enum value: " + value);
    }

    public static DecimalFormat getDecimalFormat(Field field) {
        Configurable.Gui.NumberFormat format = field.getAnnotation(Configurable.Gui.NumberFormat.class);
        if (format != null) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            return new DecimalFormat(format.value(), symbols);
        }
        return null;
    }

    public static void adjustCharacterLimit(Field field, EditBoxWidget widget) {
        Configurable.Gui.CharacterLimit limit = field.getAnnotation(Configurable.Gui.CharacterLimit.class);
        if (limit != null) {
            widget.setMaxLength(Math.max(limit.value(), 1));
        }
    }
}

