/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config;

import dev.toma.configuration.ConfigurationOptions;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public enum FieldVisibility {
    NORMAL(opt -> true, null),
    ADVANCED(opt -> opt.advancedMode, "advanced"),
    HIDDEN(opt -> false, null);

    private final Predicate<ConfigurationOptions> visibilityCheck;
    private final MutableComponent label;

    private FieldVisibility(Predicate<ConfigurationOptions> visibilityCheck, String identifier) {
        this.visibilityCheck = visibilityCheck;
        this.label = identifier != null ? Component.translatable((String)("text.configuration.description.visibility." + identifier)) : null;
    }

    public boolean isVisible(ConfigurationOptions settings) {
        return this.visibilityCheck.test(settings);
    }

    public MutableComponent getLabel() {
        return this.label;
    }
}

