/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.adapter;

import java.util.function.Function;

public interface TypeMapper<T, R> {
    public R migrate(T var1);

    public T rollback(R var1);

    public static <T> TypeMapper<T, T> identity() {
        return TypeMapper.of(t -> t, t -> t);
    }

    public static <T, R> TypeMapper<T, R> of(final Function<T, R> encoder, final Function<R, T> decoder) {
        return new TypeMapper<T, R>(){

            @Override
            public R migrate(T t) {
                return encoder.apply(t);
            }

            @Override
            public T rollback(R r) {
                return decoder.apply(r);
            }
        };
    }
}

