/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.format;

import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.format.IConfigFormatHandler;
import dev.toma.configuration.config.format.ini.IniFormat;
import dev.toma.configuration.config.format.json.GsonFormat;
import dev.toma.configuration.config.format.properties.PropertiesFormat;
import dev.toma.configuration.config.format.yaml.YamlFormat;
import java.util.function.Supplier;

public final class ConfigFormats {
    private static final String EXT_JSON = "json";
    private static final String EXT_YAML = "yaml";
    private static final String EXT_YML = "yml";
    private static final String EXT_PROPERTIES = "properties";
    private static final String EXT_INI = "ini";
    public static final IConfigFormatHandler JSON = new SimpleFormatImpl("json", GsonFormat::new);
    public static final IConfigFormatHandler YAML = new SimpleFormatImpl("yaml", YamlFormat::new);
    public static final IConfigFormatHandler YML = new SimpleFormatImpl("yml", YamlFormat::new);
    public static final IConfigFormatHandler PROPERTIES = new SimpleFormatImpl("properties", PropertiesFormat::new);
    public static final IConfigFormatHandler INI = new SimpleFormatImpl("ini", IniFormat::new);

    private record SimpleFormatImpl(String fileExt, Supplier<IConfigFormat> factory) implements IConfigFormatHandler
    {
        @Override
        public IConfigFormat createFormat() {
            return this.factory.get();
        }
    }
}

