/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.validate;

import dev.toma.configuration.config.value.INumericValue;
import java.text.DecimalFormat;
import java.util.function.Predicate;

public final class NumberRange<T extends Number>
implements Predicate<T> {
    private final T min;
    private final T max;
    private DecimalFormat customFormat;

    private NumberRange(T min, T max, INumericValue<T> value) {
        this.min = ((Comparable)value.min()).compareTo(min) < 0 ? min : value.min();
        this.max = ((Comparable)value.max()).compareTo(max) > 0 ? max : value.max();
    }

    public static <N extends Number> NumberRange<N> all(INumericValue<N> config) {
        return new NumberRange<N>(config.min(), config.max(), config);
    }

    public static <N extends Number> NumberRange<N> interval(INumericValue<N> config, N min, N max) {
        return new NumberRange<N>(min, max, config);
    }

    public T min() {
        return this.min;
    }

    public T max() {
        return this.max;
    }

    @Override
    public boolean test(T t) {
        return this.isWithinRange(t);
    }

    public String format(T value) {
        return this.customFormat != null ? this.customFormat.format(((Number)value).doubleValue()) : String.valueOf(((Number)value).doubleValue());
    }

    public void setCustomFormat(DecimalFormat format) {
        this.customFormat = format;
    }

    public boolean isWithinRange(T t) {
        int minBoundCompare = ((Comparable)t).compareTo(this.min());
        if (minBoundCompare < 0) {
            return false;
        }
        int maxBoundCompare = ((Comparable)t).compareTo(this.max());
        return maxBoundCompare <= 0;
    }

    public T clamp(T t) {
        int minBound = ((Comparable)t).compareTo(this.min());
        if (minBound < 0) {
            return this.min();
        }
        int maxBound = ((Comparable)t).compareTo(this.max());
        return maxBound > 0 ? this.max() : t;
    }
}

