/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.value;

import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.exception.ConfigValueMissingException;
import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.validate.NumberRange;
import dev.toma.configuration.config.value.AbstractArrayValue;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.IConfigValueReadable;
import dev.toma.configuration.config.value.NumericArrayValue;
import dev.toma.configuration.config.value.ValueData;
import java.lang.reflect.Field;
import net.minecraft.network.FriendlyByteBuf;

public class IntArrayValue
extends NumericArrayValue<Integer> {
    public IntArrayValue(ValueData<Integer[]> valueData) {
        super(valueData, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public NumberRange<Integer> getValueRange(Field field) {
        Configurable.Range range = field.getAnnotation(Configurable.Range.class);
        return range != null ? NumberRange.interval(this, (int)Math.max(range.min(), (long)((Integer)this.min()).intValue()), (int)Math.min(range.max(), (long)((Integer)this.max()).intValue())) : NumberRange.all(this);
    }

    @Override
    public Integer createElementInstance() {
        return 0;
    }

    @Override
    public void serialize(IConfigFormat format) {
        format.writeIntArray(this.getId(), (Integer[])this.get(IConfigValueReadable.Mode.SAVED));
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        this.setValue(format.readIntArray(this.getId()));
    }

    public static final class Adapter
    extends TypeAdapter<Integer[]> {
        @Override
        public void encodeToBuffer(ConfigValue<Integer[]> value, FriendlyByteBuf buffer) {
            AbstractArrayValue.saveToBuffer(value.get(), buffer, FriendlyByteBuf::writeInt);
        }

        @Override
        public Integer[] decodeFromBuffer(ConfigValue<Integer[]> value, FriendlyByteBuf buffer) {
            return AbstractArrayValue.readFromBuffer(buffer, Integer[]::new, FriendlyByteBuf::readInt);
        }

        @Override
        public ConfigValue<Integer[]> serialize(TypeAdapter.TypeAttributes<Integer[]> attributes, Object instance, TypeAdapter.TypeSerializer serializer) throws IllegalAccessException {
            return new IntArrayValue(ValueData.of(attributes));
        }
    }
}

