/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.widget;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;

public abstract class ContainerWidget
extends AbstractWidget
implements ContainerEventHandler {
    private final List<GuiEventListener> listeners = new ArrayList<GuiEventListener>();
    private final List<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
    private GuiEventListener focused;
    private boolean dragging;

    public ContainerWidget(int x, int y, int w, int h, Component component) {
        super(x, y, w, h, component);
    }

    public <L extends GuiEventListener> L addGuiEventListener(L listener) {
        this.listeners.add(listener);
        return listener;
    }

    public void removeGuiEventListener(GuiEventListener listener) {
        this.listeners.remove(listener);
    }

    public <W extends AbstractWidget> W addRenderableWidget(W widget) {
        this.widgets.add(widget);
        return this.addGuiEventListener((GuiEventListener)widget);
    }

    public void removeWidget(AbstractWidget widget) {
        this.widgets.remove(widget);
        this.removeGuiEventListener((GuiEventListener)widget);
    }

    public void clear() {
        this.listeners.clear();
        this.widgets.clear();
        this.focused = null;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.widgets.forEach(widget -> widget.render(graphics, mouseX, mouseY, partialTicks));
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        boolean result = super.mouseClicked(event, doubleClick);
        if (!result && this.focused != null) {
            this.setFocused(null);
        }
        return result;
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        return super.mouseReleased(event);
    }

    public boolean mouseDragged(MouseButtonEvent event, double p_231045_6_, double p_231045_8_) {
        return super.mouseDragged(event, p_231045_6_, p_231045_8_);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        return super.mouseScrolled(mouseX, mouseY, amountX, amountY);
    }

    public void mouseMoved(double p_212927_1_, double p_212927_3_) {
        super.mouseMoved(p_212927_1_, p_212927_3_);
    }

    public boolean keyPressed(KeyEvent event) {
        return super.keyPressed(event);
    }

    public boolean keyReleased(KeyEvent event) {
        return super.keyReleased(event);
    }

    public List<? extends GuiEventListener> children() {
        return this.listeners;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    public GuiEventListener getFocused() {
        return this.focused;
    }

    public void setFocused(GuiEventListener focused) {
        if (this.focused != null) {
            this.focused.setFocused(false);
        }
        if (focused != null) {
            focused.setFocused(true);
        }
        this.focused = focused;
    }
}

