/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config;

import dev.toma.configuration.config.io.ConfigurationFileManager;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public enum UpdateRestrictions {
    NONE,
    MAIN_MENU,
    GAME_RESTART;

    private final Component label = Component.translatable((String)("text.configuration.description.restriction." + this.name().toLowerCase(Locale.ROOT))).withStyle(ChatFormatting.DARK_GRAY);

    public boolean canApplyChangeInEnvironment(ConfigurationFileManager.ConfigEnvironment environment) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> true;
            case 1 -> {
                if (environment != ConfigurationFileManager.ConfigEnvironment.PLAYING) {
                    yield true;
                }
                yield false;
            }
            case 2 -> environment == ConfigurationFileManager.ConfigEnvironment.LOADING;
        };
    }

    public boolean isEditableInEnvironment(ConfigurationFileManager.ConfigEnvironment environment) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> true;
            case 1, 2 -> environment != ConfigurationFileManager.ConfigEnvironment.PLAYING;
        };
    }

    public boolean isRestricted() {
        return this != NONE;
    }

    public Component getLabel() {
        return this.label;
    }
}

