/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.validate;

import dev.toma.configuration.Configuration;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.ConfigValueLocation;
import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.validate.ValidationResult;
import dev.toma.configuration.config.validate.Validator;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.IConfigValue;
import dev.toma.configuration.config.value.IConfigValueReadable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.network.chat.Component;

public class SpecificValueValidator<V>
implements Validator<V> {
    private final ConfigValueLocation location;
    private final String[] accepts;
    private final boolean invert;

    public SpecificValueValidator(Configurable.DependsOn.ConfigValue value) {
        this(ConfigValueLocation.parse(value.location()), value.accepts(), value.invert());
    }

    public SpecificValueValidator(ConfigValueLocation location, String[] accepts, boolean invert) {
        this.location = location;
        this.accepts = accepts;
        this.invert = invert;
    }

    @Override
    public ValidationResult validate(V newValue, IConfigValueReadable<V> valueHolder) {
        ConfigHolder holder = Configuration.getConfig(this.location.namespace()).orElse(null);
        if (holder == null) {
            return ValidationResult.warning((Component)Component.translatable((String)"text.configuration.validation.config_not_found", (Object[])new Object[]{this.location}));
        }
        Component configName = holder.getTitle();
        String path = this.location.path();
        IConfigValue configValue = holder.getConfigValue(path, Object.class).orElse(null);
        if (configValue == null) {
            return ValidationResult.warning((Component)Component.translatable((String)"text.configuration.validation.field_not_found", (Object[])new Object[]{path, configName}));
        }
        Object value = holder.getValue(path, Object.class).orElse(null);
        if (value == null) {
            return ValidationResult.warning((Component)Component.translatable((String)"text.configuration.validation.value_not_found", (Object[])new Object[]{configValue.getTitle(), configName}));
        }
        String asString = value.getClass().isArray() ? Arrays.toString((Object[])value) : Objects.toString(value);
        for (String required : this.accepts) {
            if (!required.equalsIgnoreCase(asString) || this.invert) continue;
            return ValidationResult.success();
        }
        ArrayList<Component> warningLabel = new ArrayList<Component>();
        Component fieldName = configValue.getTitle();
        warningLabel.add((Component)Component.translatable((String)"text.configuration.validation.value_required", (Object[])new Object[]{fieldName, configName}));
        for (String acceptedValue : this.accepts) {
            warningLabel.add((Component)Component.literal((String)("- " + acceptedValue)));
        }
        return ValidationResult.warning(warningLabel);
    }

    @Override
    public void onGameLoaded(IConfigValue<V> v) {
        ConfigValue configValue = (ConfigValue)v;
        Configuration.getConfigValueHolder(this.location, Object.class).ifPresent(value -> value.addListener((cfgValue, updatedValue) -> configValue.validateAndStoreResult(configValue.getActiveValue())));
    }
}

