/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.value;

import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.exception.ConfigValueMissingException;
import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.IConfigValueReadable;
import dev.toma.configuration.config.value.ValueData;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;

public class EnumValue<E extends Enum<E>>
extends ConfigValue<E> {
    public EnumValue(ValueData<E> valueData) {
        super(valueData);
    }

    @Override
    protected void serialize(IConfigFormat format) {
        format.addComments(EnumValue.getValidEnumEntriesAsString(this.valueData.getValueType()));
        format.writeEnum(this.getId(), (Enum)this.get(IConfigValueReadable.Mode.SAVED));
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        this.setValue(format.readEnum(this.getId(), this.getValueType()));
    }

    static <E extends Enum<E>> String getValidEnumEntriesAsString(Class<E> enumType) {
        List<String> values = Arrays.stream((Enum[])enumType.getEnumConstants()).map(Enum::name).toList();
        return "Allowed values: [" + String.join((CharSequence)", ", values) + "]";
    }

    public static final class Adapter<E extends Enum<E>>
    extends TypeAdapter<E> {
        @Override
        public ConfigValue<E> serialize(TypeAdapter.TypeAttributes<E> attributes, Object instance, TypeAdapter.TypeSerializer serializer) throws IllegalAccessException {
            return new EnumValue<E>(ValueData.of(attributes));
        }

        @Override
        public void encodeToBuffer(ConfigValue<E> value, FriendlyByteBuf buffer) {
            buffer.writeEnum((Enum)value.get());
        }

        @Override
        public E decodeFromBuffer(ConfigValue<E> value, FriendlyByteBuf buffer) {
            Class<E> type = value.getValueType();
            return (E)buffer.readEnum(type);
        }
    }
}

