/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.value;

import dev.toma.configuration.config.ConfigUtils;
import dev.toma.configuration.config.validate.NumberRange;
import dev.toma.configuration.config.validate.ValueFixer;
import dev.toma.configuration.config.value.AbstractArrayValue;
import dev.toma.configuration.config.value.INumericValue;
import dev.toma.configuration.config.value.ValueData;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Field;

public abstract class NumericArrayValue<T extends Number>
extends AbstractArrayValue<T>
implements INumericValue<T> {
    private final T minValue;
    private final T maxValue;
    private NumberRange<T> range;

    public NumericArrayValue(ValueData<T[]> valueData, T minValue, T maxValue) {
        super(valueData);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.addFixer((ValueFixer<Number[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, fixValue(java.lang.Number[] ), ([Ljava/lang/Number;)[Ljava/lang/Number;)((NumericArrayValue)this));
    }

    public abstract NumberRange<T> getValueRange(Field var1);

    @Override
    protected void processAdditionalAnnotations(Field field) {
        super.processAdditionalAnnotations(field);
        this.range = this.getValueRange(field);
    }

    @Override
    public final T min() {
        return this.minValue;
    }

    @Override
    public final T max() {
        return this.maxValue;
    }

    @Override
    public final NumberRange<T> getRange() {
        return this.range;
    }

    private T[] fixValue(T[] in) {
        for (int i = 0; i < in.length; ++i) {
            T num = in[i];
            if (this.range == null || this.range.isWithinRange(num)) continue;
            T clamped = this.range.clamp(num);
            ConfigUtils.logCorrectedMessage(this.getId() + "[" + i + "]", num, clamped);
            in[i] = clamped;
        }
        return in;
    }
}

