/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.client.overlay;

import java.util.Locale;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.client.gui.GuiLayer;
import tnt.tarkovcraft.core.TarkovCraftCore;
import tnt.tarkovcraft.core.api.StaminaComponent;
import tnt.tarkovcraft.core.client.TarkovCraftCoreClient;
import tnt.tarkovcraft.core.common.attribute.EntityAttributeData;
import tnt.tarkovcraft.core.common.energy.EnergySystem;
import tnt.tarkovcraft.core.common.init.CoreAttributes;
import tnt.tarkovcraft.core.common.init.CoreDataAttachments;

public class DebugLayer
implements GuiLayer {
    public static final ResourceLocation LAYER_ID = TarkovCraftCore.createResourceLocation("layer/debug");
    private int line;

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (!TarkovCraftCoreClient.getConfig().renderDebugOverlay) {
            return;
        }
        this.line = 0;
        Minecraft client = Minecraft.getInstance();
        Font font = client.font;
        LocalPlayer player = client.player;
        EntityAttributeData attributeData = (EntityAttributeData)player.getData(CoreDataAttachments.ENTITY_ATTRIBUTES);
        guiGraphics.drawString(font, "Move Stamina Component: " + String.valueOf(EnergySystem.MOVEMENT_STAMINA), 5, this.y(), -1);
        guiGraphics.drawString(font, "Arm Stamina Component: " + String.valueOf(EnergySystem.ARM_STAMINA), 5, this.y(), -1);
        this.renderEnergyStats(font, guiGraphics, (Player)player);
        this.renderCoreAttributeData(font, guiGraphics, attributeData);
    }

    private void renderEnergyStats(Font font, GuiGraphics graphics, Player player) {
        this.renderStaminaInfo(font, graphics, player, "Sprint stamina", EnergySystem.MOVEMENT_STAMINA.getComponent());
        this.renderStaminaInfo(font, graphics, player, "Arm stamina", EnergySystem.ARM_STAMINA.getComponent());
        ++this.line;
    }

    private void renderCoreAttributeData(Font font, GuiGraphics graphics, EntityAttributeData attributeData) {
        graphics.drawString(font, "Core Attributes", 5, this.y(), -1);
        float forgetRate = attributeData.getAttribute(CoreAttributes.MEMORY_FORGET_TIME_MULTIPLIER).floatValue();
        graphics.drawString(font, String.format(Locale.ROOT, "Memory forget rate: %.2f", Float.valueOf(forgetRate)), 5, this.y(), -1);
        float forgetAmount = attributeData.getAttribute(CoreAttributes.MEMORY_FORGET_AMOUNT_MULTIPLIER).floatValue();
        graphics.drawString(font, String.format(Locale.ROOT, "Memory forget amount: %.2f", Float.valueOf(forgetAmount)), 5, this.y(), -1);
        ++this.line;
    }

    private void renderStaminaInfo(Font font, GuiGraphics graphics, Player player, String name, StaminaComponent component) {
        if (component.shouldRenderOverlay((LivingEntity)player)) {
            float current = component.getStamina((LivingEntity)player);
            float max = component.getMaxStamina((LivingEntity)player);
            String value = String.format(Locale.ROOT, "%s: %.2f/%.2f", name, Float.valueOf(current), Float.valueOf(max));
            graphics.drawString(font, value, 5, this.y(), -1);
        }
    }

    private int y() {
        return 5 + 10 * this.line++;
    }
}

