/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.client.screen.renderable;

import dev.toma.configuration.config.validate.ValidationResult;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import tnt.tarkovcraft.core.client.screen.renderable.AbstractRenderable;

public class ValidationMessageRenderable
extends AbstractRenderable {
    private final boolean onlyWarnOrError;
    private final Font font;
    private final Supplier<ValidationResult> resultProvider;

    public ValidationMessageRenderable(int x, int y, int width, int height, boolean onlyWarnOrError, Font font, Supplier<ValidationResult> resultProvider) {
        super(x, y, width, height);
        this.onlyWarnOrError = onlyWarnOrError;
        this.font = font;
        this.resultProvider = resultProvider;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ValidationResult result = this.resultProvider.get();
        ValidationResult.Type type = result.type();
        if (!this.onlyWarnOrError || type.isWarningOrError()) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, type.iconPath, this.x, this.y, 0.0f, 0.0f, 10, 10, 16, 16, 16, 16);
            List messages = result.description();
            if (this.height >= 10 && !messages.isEmpty()) {
                int renderCount = Math.min(this.height / 10, messages.size());
                for (int i = 0; i < renderCount; ++i) {
                    Component message = (Component)messages.get(i);
                    MutableComponent text = message.copy().withStyle(ChatFormatting.ITALIC);
                    guiGraphics.drawScrollingString(this.font, (Component)text, this.x + 12, this.getRight(), this.y + 2 + i * 10, type.textColor);
                }
            }
        }
    }
}

