/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.skill;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.ApiStatus;
import tnt.tarkovcraft.core.TarkovCraftCore;
import tnt.tarkovcraft.core.common.config.SkillSystemConfig;
import tnt.tarkovcraft.core.common.init.CoreDataAttachments;
import tnt.tarkovcraft.core.common.init.CoreRegistries;
import tnt.tarkovcraft.core.common.skill.SkillData;
import tnt.tarkovcraft.core.common.skill.SkillDefinition;
import tnt.tarkovcraft.core.common.skill.tracker.SkillTrackerDefinition;
import tnt.tarkovcraft.core.common.skill.tracker.SkillTriggerEvent;

public final class SkillSystem {
    public static final Marker MARKER = MarkerManager.getMarker((String)"SkillSystem");
    private static final Multimap<SkillTriggerEvent, SkillDefinition> TRIGGER_CACHE = ArrayListMultimap.create();

    public static boolean isSkillSystemEnabled() {
        return TarkovCraftCore.getConfig().skillSystemConfig.skillSystemEnabled;
    }

    public static boolean isMemoryEnabled() {
        SkillSystemConfig cfg = TarkovCraftCore.getConfig().skillSystemConfig;
        return cfg.enableSkillExperienceLoss;
    }

    public static boolean isLevelMemoryEnabled() {
        SkillSystemConfig cfg = TarkovCraftCore.getConfig().skillSystemConfig;
        return cfg.enableSkillLevelLoss;
    }

    public static void synchronize(Entity entity) {
        entity.syncData(CoreDataAttachments.SKILL);
    }

    public static boolean trigger(SkillTriggerEvent event, Entity entity, float multiplier) {
        if (!SkillSystem.isSkillSystemEnabled()) {
            return false;
        }
        SkillData data = (SkillData)entity.getData(CoreDataAttachments.SKILL);
        Collection definitions = TRIGGER_CACHE.get((Object)event);
        boolean anyTrigger = false;
        for (SkillDefinition definition : definitions) {
            if (!data.trigger(event, definition, multiplier, entity)) continue;
            anyTrigger = true;
        }
        return anyTrigger;
    }

    public static boolean trigger(Supplier<SkillTriggerEvent> event, Entity entity, float multiplier) {
        return SkillSystem.trigger(event.get(), entity, multiplier);
    }

    public static boolean trigger(Holder<SkillTriggerEvent> event, Entity entity, float multiplier) {
        return SkillSystem.trigger((SkillTriggerEvent)event.value(), entity, multiplier);
    }

    public static boolean trigger(SkillTriggerEvent event, Entity entity) {
        return SkillSystem.trigger(event, entity, 1.0f);
    }

    public static boolean trigger(Supplier<SkillTriggerEvent> event, Entity entity) {
        return SkillSystem.trigger(event, entity, 1.0f);
    }

    public static boolean trigger(Holder<SkillTriggerEvent> event, Entity entity) {
        return SkillSystem.trigger(event, entity, 1.0f);
    }

    public static void triggerAndSynchronize(SkillTriggerEvent event, Entity entity, float multiplier) {
        if (SkillSystem.trigger(event, entity, multiplier)) {
            SkillSystem.synchronize(entity);
        }
    }

    public static void triggerAndSynchronize(Supplier<SkillTriggerEvent> event, Entity entity, float multiplier) {
        SkillSystem.triggerAndSynchronize(event.get(), entity, multiplier);
    }

    public static void triggerAndSynchronize(Holder<SkillTriggerEvent> event, Entity entity, float multiplier) {
        SkillSystem.triggerAndSynchronize((SkillTriggerEvent)event.value(), entity, multiplier);
    }

    public static void triggerAndSynchronize(SkillTriggerEvent event, Entity entity) {
        SkillSystem.triggerAndSynchronize(event, entity, 1.0f);
    }

    public static void triggerAndSynchronize(Supplier<SkillTriggerEvent> event, Entity entity) {
        SkillSystem.triggerAndSynchronize(event, entity, 1.0f);
    }

    public static void triggerAndSynchronize(Holder<SkillTriggerEvent> event, Entity entity) {
        SkillSystem.triggerAndSynchronize(event, entity, 1.0f);
    }

    @ApiStatus.Internal
    public static void onServerStarted(ServerStartedEvent event) {
        TRIGGER_CACHE.clear();
        MinecraftServer server = event.getServer();
        RegistryAccess.Frozen access = server.registryAccess();
        Registry registry = access.lookupOrThrow(CoreRegistries.DatapackKeys.SKILL_DEFINITION);
        registry.listElements().map(Holder.Reference::value).filter(SkillDefinition::isEnabled).forEach(definition -> {
            for (SkillTrackerDefinition trackerDefinition : definition.getTrackers()) {
                SkillTriggerEvent triggerEvent = trackerDefinition.event();
                TRIGGER_CACHE.put((Object)triggerEvent, definition);
            }
        });
    }
}

